/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.io;

import java.util.HashSet;
import java.util.Set;

public class SheetNameChecker {
    private final Set<String> existingNameSet = new HashSet<String>();

    public String checkName(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name is null");
        }
        if (!this.existingNameSet.contains(name = SheetNameChecker.checkNameCharacters(name))) {
            this.existingNameSet.add(name);
            return name;
        }
        int p = 2;
        while (true) {
            String newName;
            if (!this.existingNameSet.contains(newName = name + " (" + p + ")")) {
                this.existingNameSet.add(newName);
                return newName;
            }
            ++p;
        }
    }

    public static String checkNameCharacters(String name) {
        int length = name.length();
        StringBuilder buf = new StringBuilder(length + 10);
        for (int i = 0; i < length; ++i) {
            char carac = name.charAt(i);
            switch (carac) {
                case '[': {
                    carac = '(';
                    break;
                }
                case ']': {
                    carac = ')';
                    break;
                }
                case '*': 
                case '/': 
                case ':': 
                case '?': 
                case '\\': {
                    carac = '-';
                }
            }
            buf.append(carac);
        }
        return buf.toString();
    }
}

