/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.css.parse;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import net.mapeadores.opendocument.css.parse.CssErrorHandler;
import net.mapeadores.opendocument.css.parse.CssSource;
import net.mapeadores.opendocument.css.parse.DistCssSource;
import net.mapeadores.opendocument.css.parse.FileCssSource;
import net.mapeadores.opendocument.css.parse.OdCssDocumentHandler;
import net.mapeadores.opendocument.elements.ElementMaps;
import net.mapeadores.opendocument.elements.OdLibException;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.helpers.ParserFactory;

public class CssParser {
    public static final CssErrorHandler NULL_ERRORHANDLER = new NullErrorHandler();
    public static final CssErrorHandler OUT_ERRORHANDLER = new OutErrorHandler();

    public static ElementMaps parse(CssSource cssSource, CssErrorHandler errorHandler) throws IOException {
        if (errorHandler == null) {
            errorHandler = NULL_ERRORHANDLER;
        }
        Reader reader = cssSource.getReader();
        InputSource inputSource = new InputSource(reader);
        OdCssDocumentHandler documentHandler = new OdCssDocumentHandler();
        ParserFactory parserFactory = new ParserFactory();
        try {
            Parser parser = parserFactory.makeParser();
            parser.setDocumentHandler((DocumentHandler)documentHandler);
            parser.setErrorHandler((ErrorHandler)errorHandler);
            errorHandler.setCurrentURI(cssSource.getCssSourceURI());
            parser.parseStyleSheet(inputSource);
        }
        catch (ClassNotFoundException nf) {
            throw new OdLibException(nf);
        }
        catch (IllegalAccessException nf) {
            throw new OdLibException(nf);
        }
        catch (InstantiationException nf) {
            throw new OdLibException(nf);
        }
        ElementMaps elementMaps = documentHandler.getElementMaps();
        List<String> list = documentHandler.getImportList();
        int size = list.size();
        if (size > 0) {
            for (int i = size - 1; i >= 0; --i) {
                String url = list.get(i);
                CssSource importSource = cssSource.getImportCssSource(url);
                if (importSource == null) continue;
                ElementMaps importElementMaps = CssParser.parse(importSource, errorHandler);
                elementMaps.append(importElementMaps);
            }
        }
        return elementMaps;
    }

    public static ElementMaps parse(File file, CssErrorHandler errorHandler) throws IOException {
        FileCssSource cssSource = new FileCssSource(file);
        return CssParser.parse(cssSource, errorHandler);
    }

    public static ElementMaps parseDist(Class referenceClass, String path, CssErrorHandler cssErrorHandler) throws IOException {
        return CssParser.parse(new DistCssSource(referenceClass, path), cssErrorHandler);
    }

    private static class NullErrorHandler
    implements CssErrorHandler {
        private NullErrorHandler() {
        }

        @Override
        public void setCurrentURI(String uri) {
        }

        public void error(CSSParseException exception) throws CSSException {
        }

        public void fatalError(CSSParseException exception) throws CSSException {
        }

        public void warning(CSSParseException exception) throws CSSException {
        }

        @Override
        public void unknownURIFatalError(String uri) {
        }
    }

    private static class OutErrorHandler
    implements CssErrorHandler {
        private String currentURI;

        @Override
        public void setCurrentURI(String uri) {
            this.currentURI = uri;
        }

        public void error(CSSParseException exception) throws CSSException {
            System.out.println(this.currentURI + " / " + exception.getMessage());
        }

        public void fatalError(CSSParseException exception) throws CSSException {
            System.out.println(this.currentURI + " / " + exception.getMessage());
        }

        public void warning(CSSParseException exception) throws CSSException {
            System.out.println(this.currentURI + " / " + exception.getMessage());
        }

        @Override
        public void unknownURIFatalError(String uri) {
            System.out.println(uri + " / Unknown URI");
        }
    }
}

