/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.defs;

import java.io.IOException;
import java.util.List;
import net.fichotheque.exportation.balayage.BalayageDef;
import net.fichotheque.exportation.balayage.BalayageOutput;
import net.fichotheque.exportation.balayage.BalayagePostscriptum;
import net.fichotheque.exportation.balayage.BalayageUnit;
import net.fichotheque.selection.DocumentQuery;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.IllustrationQuery;
import net.fichotheque.selection.MotcleQuery;
import net.fichotheque.utils.FichothequeXMLUtils;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.text.AccoladePattern;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class BalayageDefXMLPart
extends XMLPart {
    public BalayageDefXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
    }

    public BalayageDefXMLPart addBalayageDef(BalayageDef balayageDef) throws IOException {
        this.openTag("balayage");
        LabelUtils.addLabels(this, balayageDef.getTitleLabels());
        Langs langs = balayageDef.getLangs();
        if (!langs.isEmpty()) {
            this.openTag("langs");
            for (Lang lang : langs) {
                this.addSimpleElement("lang", lang.toString());
            }
            this.closeTag("langs");
        }
        this.addSimpleElement("target-name", balayageDef.getTargetName());
        this.addSimpleElement("target-path", balayageDef.getTargetPath().toString());
        this.addSimpleElement("default-lang-option", balayageDef.getDefaultLangOption());
        this.addBoolean("ignore-transformation", balayageDef.ignoreTransformation());
        this.addPostcriptum(balayageDef.getPostscriptum());
        this.addUnits(balayageDef.getBalayageUnitList());
        FichothequeXMLUtils.writeSelectionOptions(this, balayageDef.getSelectionOptions());
        AttributeUtils.addAttributes(this, balayageDef.getAttributes());
        this.closeTag("balayage");
        return this;
    }

    private void addPostcriptum(BalayagePostscriptum postscriptum) throws IOException {
        this.openTag("postscriptum");
        this.addList(postscriptum.getExternalScriptNameList(), "script");
        this.addList(postscriptum.getScrutariExportNameList(), "scrutari");
        this.addList(postscriptum.getSqlExportNameList(), "sql");
        this.closeTag("postscriptum");
    }

    private void addList(List<String> valueList, String tagName) throws IOException {
        for (String value : valueList) {
            this.addSimpleElement(tagName, value);
        }
    }

    private void addUnits(List<BalayageUnit> list) throws IOException {
        this.openTag("units");
        for (BalayageUnit balayageUnit : list) {
            this.addBalayageUnit(balayageUnit);
        }
        this.closeTag("units");
    }

    public BalayageDefXMLPart addBalayageUnit(BalayageUnit balayageUnit) throws IOException {
        String type = balayageUnit.getType();
        String tagName = BalayageDefXMLPart.getTagName(type);
        this.startOpenTag(tagName);
        this.addAttribute("name", balayageUnit.getName());
        if (!balayageUnit.isGlobalSelect()) {
            this.addAttribute("global-select", "false");
        }
        this.addAttribute("extraction", balayageUnit.getExtractionPath());
        this.addAttribute("mode", StringUtils.implode(balayageUnit.getModeList(), ' '));
        this.endOpenTag();
        switch (type) {
            case "corpus": 
            case "fiche": {
                this.addFicheQuery(balayageUnit);
                break;
            }
            case "thesaurus": 
            case "motcle": {
                this.addMotcleQuery(balayageUnit);
                break;
            }
            case "document": {
                this.addFicheQuery(balayageUnit);
                this.addDocumentQuery(balayageUnit);
                break;
            }
            case "illustration": {
                this.addIllustrationQuery(balayageUnit);
            }
        }
        for (String extension : balayageUnit.getExtensionList()) {
            this.addSimpleElement("extension", extension);
        }
        for (BalayageOutput output : balayageUnit.getOutputList()) {
            this.addOutput(output);
        }
        this.closeTag(tagName);
        return this;
    }

    private void addFicheQuery(BalayageUnit balayageUnit) throws IOException {
        FicheQuery ficheQuery = balayageUnit.getFicheQuery();
        if (ficheQuery.isEmpty()) {
            return;
        }
        FichothequeXMLUtils.writeFicheQuery(this, ficheQuery);
    }

    private void addMotcleQuery(BalayageUnit balayageUnit) throws IOException {
        MotcleQuery motcleQuery = balayageUnit.getMotcleQuery();
        if (motcleQuery.isEmpty()) {
            return;
        }
        FichothequeXMLUtils.writeMotcleQuery(this, motcleQuery);
    }

    private void addIllustrationQuery(BalayageUnit balayageUnit) throws IOException {
        IllustrationQuery illustrationQuery = balayageUnit.getIllustrationQuery();
        if (illustrationQuery.isEmpty()) {
            return;
        }
        FichothequeXMLUtils.writeIllustrationQuery(this, illustrationQuery);
    }

    private void addDocumentQuery(BalayageUnit balayageUnit) throws IOException {
        DocumentQuery documentQuery = balayageUnit.getDocumentQuery();
        if (documentQuery.isEmpty()) {
            return;
        }
        FichothequeXMLUtils.writeDocumentQuery(this, documentQuery);
    }

    private void addOutput(BalayageOutput output) throws IOException {
        List<BalayageOutput.Param> paramList;
        Langs langs;
        this.startOpenTag("output");
        this.addAttribute("name", output.getName());
        this.addAttribute("xslt", output.getXsltPath());
        AccoladePattern pattern = output.getPattern();
        if (pattern != null) {
            this.addAttribute("pattern", pattern.toString());
        }
        if (output.isIncludeOutput()) {
            this.addAttribute("path", "_inc_/");
        } else {
            AccoladePattern outputPathPattern = output.getOutputPath();
            if (outputPathPattern != null) {
                this.addAttribute("path", outputPathPattern.toString());
            }
        }
        this.addAttribute("mode", output.getName());
        this.addAttribute("posttransform", output.getPosttransform());
        if (output.isCleanBefore()) {
            this.addAttribute("clean", "true");
        }
        if ((langs = output.getCustomLangs()) != null) {
            this.addAttribute("langs", langs.toString(";"));
        }
        if ((paramList = output.getParamList()).isEmpty()) {
            this.closeEmptyTag();
        } else {
            this.endOpenTag();
            for (BalayageOutput.Param param : paramList) {
                this.startOpenTag("param");
                this.addAttribute("name", param.getName());
                this.addAttribute("value", param.getValue());
                this.closeEmptyTag();
            }
            this.closeTag("output");
        }
    }

    private void addBoolean(String name, boolean value) throws IOException {
        if (value) {
            this.addEmptyElement(name);
        }
    }

    public static BalayageDefXMLPart init(XMLWriter xmlWriter) {
        return new BalayageDefXMLPart(xmlWriter);
    }

    private static String getTagName(String unitType) {
        switch (unitType) {
            case "unique": {
                return "unique-balayage";
            }
            case "corpus": {
                return "corpus-balayage";
            }
            case "fiche": {
                return "fiche-balayage";
            }
            case "thesaurus": {
                return "thesaurus-balayage";
            }
            case "motcle": {
                return "motcle-balayage";
            }
            case "document": {
                return "document-balayage";
            }
            case "illustration": {
                return "illustration-balayage";
            }
        }
        throw new IllegalArgumentException("wrong type value: " + unitType);
    }
}

