/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.thesaurus;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.include.IconSources;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.include.IncludeMode;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.attr.Attribute;

public final class IconSourcesParser {
    private IconSourcesParser() {
    }

    public static IconSources parse(Fichotheque fichotheque, Attribute attribute) {
        ArrayList<InternalEntry> entryList = new ArrayList<InternalEntry>();
        HashSet<IncludeKey> doneSet = new HashSet<IncludeKey>();
        for (String value : attribute) {
            try {
                IncludeKey includeKey = IncludeKey.parse(value);
                if (doneSet.contains(includeKey)) continue;
                doneSet.add(includeKey);
                Subset subset = fichotheque.getSubset(includeKey.getSubsetKey());
                if (subset == null || !(subset instanceof Thesaurus)) continue;
                entryList.add(new InternalEntry((Thesaurus)subset, includeKey));
            }
            catch (ParseException parseException) {}
        }
        return new InternalIconSources(ThesaurusUtils.wrap(entryList.toArray(new IconSources.Entry[entryList.size()])));
    }

    private static class InternalEntry
    implements IconSources.Entry {
        private final Thesaurus thesaurus;
        private final IncludeMode includeMode;

        private InternalEntry(Thesaurus thesaurus, IncludeMode includeMode) {
            this.thesaurus = thesaurus;
            this.includeMode = includeMode;
        }

        @Override
        public Thesaurus getThesaurus() {
            return this.thesaurus;
        }

        @Override
        public IncludeMode getIncludeMode() {
            return this.includeMode;
        }
    }

    private static class InternalIconSources
    implements IconSources {
        private final List<IconSources.Entry> entryList;

        private InternalIconSources(List<IconSources.Entry> entryList) {
            this.entryList = entryList;
        }

        @Override
        public List<IconSources.Entry> getEntryList() {
            return this.entryList;
        }
    }
}

