/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.selection;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.selection.FicheCondition;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.FieldContentCondition;
import net.fichotheque.selection.MotcleCondition;
import net.fichotheque.selection.PeriodCondition;
import net.fichotheque.selection.RangeCondition;
import net.fichotheque.selection.SubsetCondition;
import net.fichotheque.selection.UserCondition;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.fichotheque.utils.SelectionUtils;
import net.fichotheque.utils.selection.FicheConditionBuilder;
import net.fichotheque.utils.selection.MotcleConditionBuilder;
import net.mapeadores.util.conditions.TextCondition;

public class FicheQueryBuilder {
    private final Set<SubsetKey> corpusKeySet = new LinkedHashSet<SubsetKey>();
    private final Set<FieldKey> fieldKeySet = new LinkedHashSet<FieldKey>();
    private final MotcleConditionBuilder motcleConditionBuilder = MotcleConditionBuilder.init().setLogicalOperator("and");
    private final FicheConditionBuilder ficheConditionBuilder = FicheConditionBuilder.init().setLogicalOperator("and");
    private TextCondition fieldContentTextCondition = null;
    private String fieldContentScope = "fiche";
    private PeriodCondition periodCondition = null;
    private RangeCondition idRangeCondition = null;
    private UserCondition userCondition = null;
    private boolean withCurrentCorpus = false;
    private boolean exclude = false;
    private String discardFilter = "all";
    private boolean withGeoloc = false;

    public FicheQueryBuilder addCorpus(Object object) {
        block8: {
            block9: {
                block7: {
                    if (object == null) {
                        return this;
                    }
                    if (!(object instanceof Corpus)) break block7;
                    this.corpusKeySet.add(((Corpus)object).getSubsetKey());
                    break block8;
                }
                if (!(object instanceof SubsetKey)) break block9;
                SubsetKey subsetKey = (SubsetKey)object;
                if (!subsetKey.isCorpusSubset()) break block8;
                this.corpusKeySet.add(subsetKey);
                break block8;
            }
            if (object instanceof Collection) {
                for (Object obj : (Collection)object) {
                    SubsetKey subsetKey;
                    if (obj == null) continue;
                    if (obj instanceof Corpus) {
                        this.corpusKeySet.add(((Corpus)obj).getSubsetKey());
                        continue;
                    }
                    if (!(obj instanceof SubsetKey) || !(subsetKey = (SubsetKey)obj).isCorpusSubset()) continue;
                    this.corpusKeySet.add(subsetKey);
                }
            } else if (object instanceof SubsetKey[]) {
                for (SubsetKey subsetKey : (SubsetKey[])object) {
                    if (subsetKey == null || !subsetKey.isCorpusSubset()) continue;
                    this.corpusKeySet.add(subsetKey);
                }
            }
        }
        return this;
    }

    public FicheQueryBuilder clearCorpus() {
        this.corpusKeySet.clear();
        return this;
    }

    public FicheQueryBuilder addMotcleConditionEntry(MotcleCondition.Entry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("entry is null");
        }
        this.motcleConditionBuilder.addEntry(entry);
        return this;
    }

    public FicheQueryBuilder setMotcleLogicalOperator(String motcleLogicalOperator) {
        this.motcleConditionBuilder.setLogicalOperator(motcleLogicalOperator);
        return this;
    }

    public FicheQueryBuilder addFicheConditionQuery(FicheCondition.Entry entry) {
        if (entry == null) {
            throw new IllegalArgumentException("ficheQuery is null");
        }
        this.ficheConditionBuilder.addEntry(entry);
        return this;
    }

    public FicheQueryBuilder setFicheLogicalOperator(String ficheLogicalOperator) {
        this.ficheConditionBuilder.setLogicalOperator(ficheLogicalOperator);
        return this;
    }

    public FicheQueryBuilder setWithCurrentCorpus(boolean withCurrentCorpus) {
        this.withCurrentCorpus = withCurrentCorpus;
        return this;
    }

    public FicheQueryBuilder setExclude(boolean exclude) {
        this.exclude = exclude;
        return this;
    }

    public FicheQueryBuilder setFieldContentCondition(TextCondition textCondition, String scope, Collection<FieldKey> fieldKeys) {
        this.fieldContentScope = FieldContentCondition.checkScope(scope);
        this.fieldContentTextCondition = textCondition;
        this.fieldKeySet.clear();
        if (scope.equals("selection")) {
            if (fieldKeys == null) {
                throw new IllegalArgumentException("fieldKeys is null");
            }
            if (fieldKeys.isEmpty()) {
                throw new IllegalArgumentException("fieldKeys is empty");
            }
            this.fieldKeySet.addAll(fieldKeys);
        }
        return this;
    }

    public FicheQueryBuilder setPeriodCondition(PeriodCondition periodCondition) {
        this.periodCondition = periodCondition;
        return this;
    }

    public FicheQueryBuilder setIdRangeCondition(RangeCondition idRangeCondition) {
        this.idRangeCondition = idRangeCondition;
        return this;
    }

    public FicheQueryBuilder setUserCondition(UserCondition userCondition) {
        this.userCondition = userCondition;
        return this;
    }

    public FicheQueryBuilder setDiscardFilter(String discardFilter) {
        this.discardFilter = FicheQuery.checkDiscardFilter(discardFilter);
        return this;
    }

    public FicheQueryBuilder setWithGeoloc(boolean withGeoloc) {
        this.withGeoloc = withGeoloc;
        return this;
    }

    public FicheQuery toFicheQuery() {
        SubsetCondition corpusCondition = SelectionUtils.toSubsetCondition(new LinkedHashSet<SubsetKey>(this.corpusKeySet), this.withCurrentCorpus, this.exclude);
        InternalFieldContentCondition fieldContentCondition = null;
        if (this.fieldContentTextCondition != null) {
            List<FieldKey> fieldKeyList = this.fieldKeySet.isEmpty() ? CorpusMetadataUtils.EMPTY_FIELDKEYLIST : CorpusMetadataUtils.wrap(this.fieldKeySet.toArray(new FieldKey[this.fieldKeySet.size()]));
            fieldContentCondition = new InternalFieldContentCondition(this.fieldContentScope, fieldKeyList, this.fieldContentTextCondition);
        }
        MotcleCondition motcleCondition = this.motcleConditionBuilder.isEmpty() ? null : this.motcleConditionBuilder.toMotcleCondition();
        FicheCondition ficheCondition = this.ficheConditionBuilder.isEmpty() ? null : this.ficheConditionBuilder.toFicheCondition();
        return new InternalFicheQuery(corpusCondition, this.idRangeCondition, motcleCondition, ficheCondition, fieldContentCondition, this.periodCondition, this.userCondition, this.discardFilter, this.withGeoloc);
    }

    public static FicheQueryBuilder init() {
        return new FicheQueryBuilder();
    }

    private static class InternalFieldContentCondition
    implements FieldContentCondition {
        private final String scope;
        private final List<FieldKey> fieldKeyList;
        private final TextCondition textCondition;

        private InternalFieldContentCondition(String scope, List<FieldKey> fieldKeyList, TextCondition textCondition) {
            this.scope = scope;
            this.fieldKeyList = fieldKeyList;
            this.textCondition = textCondition;
        }

        @Override
        public String getScope() {
            return this.scope;
        }

        @Override
        public List<FieldKey> getFieldKeyList() {
            return this.fieldKeyList;
        }

        @Override
        public TextCondition getTextCondition() {
            return this.textCondition;
        }
    }

    private static class InternalFicheQuery
    implements FicheQuery {
        private final SubsetCondition corpusCondition;
        private final MotcleCondition motcleCondition;
        private final FicheCondition ficheCondition;
        private final FieldContentCondition fieldContentCondition;
        private final RangeCondition idRangeCondition;
        private final PeriodCondition periodCondition;
        private final UserCondition userCondition;
        private final String discardFilter;
        private final boolean withGeoloc;

        private InternalFicheQuery(SubsetCondition corpusCondition, RangeCondition idRangeCondition, MotcleCondition motcleCondition, FicheCondition ficheCondition, FieldContentCondition fieldContentCondition, PeriodCondition periodCondition, UserCondition userCondition, String discardFilter, boolean withGeoloc) {
            this.corpusCondition = corpusCondition;
            this.motcleCondition = motcleCondition;
            this.ficheCondition = ficheCondition;
            this.fieldContentCondition = fieldContentCondition;
            this.idRangeCondition = idRangeCondition;
            this.periodCondition = periodCondition;
            this.userCondition = userCondition;
            this.discardFilter = discardFilter;
            this.withGeoloc = withGeoloc;
        }

        @Override
        public SubsetCondition getCorpusCondition() {
            return this.corpusCondition;
        }

        @Override
        public MotcleCondition getMotcleCondition() {
            return this.motcleCondition;
        }

        @Override
        public FicheCondition getFicheCondition() {
            return this.ficheCondition;
        }

        @Override
        public FieldContentCondition getFieldContentCondition() {
            return this.fieldContentCondition;
        }

        @Override
        public PeriodCondition getPeriodCondition() {
            return this.periodCondition;
        }

        @Override
        public RangeCondition getIdRangeCondition() {
            return this.idRangeCondition;
        }

        @Override
        public UserCondition getUserCondition() {
            return this.userCondition;
        }

        @Override
        public String getDiscardFilter() {
            return this.discardFilter;
        }

        @Override
        public boolean isWithGeoloc() {
            return this.withGeoloc;
        }
    }
}

