/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.span;

import net.fichotheque.corpus.fiche.S;
import net.fichotheque.tools.parsers.TypoParser;
import net.fichotheque.tools.parsers.span.SpanParseResult;
import net.fichotheque.tools.parsers.span.SpanParser;
import net.mapeadores.util.text.TypoOptions;

class EmphasisParser
extends SpanParser {
    private final TypoOptions typoOptions;

    EmphasisParser(TypoOptions typoOptions) {
        this.typoOptions = typoOptions;
    }

    @Override
    public char getStartChar() {
        return '{';
    }

    @Override
    public SpanParseResult parse(String source, int startIndex) {
        char carac;
        int length = source.length();
        int braceCount = 1;
        int realStart = startIndex + 1;
        for (int i = startIndex + 1; i < length && (carac = source.charAt(i)) == '{'; ++i) {
            ++realStart;
            if (++braceCount == 3) break;
        }
        short type = braceCount == 2 ? (short)2 : (braceCount == 3 ? (short)4 : 1);
        if (realStart == length - 1) {
            return EmphasisParser.getErrorResult(type);
        }
        int stopIndex = EmphasisParser.getStopIndex(source, realStart, '}');
        if (stopIndex == -1) {
            return EmphasisParser.getErrorResult(type);
        }
        String value = EmphasisParser.getValue(source, realStart, stopIndex, '}');
        value = TypoParser.parseTypo(value, this.typoOptions);
        stopIndex = this.checkEndIndex(source, stopIndex);
        S span = new S(type);
        span.setValue(value);
        return new SpanParseResult(span, stopIndex);
    }

    private int checkEndIndex(String source, int stopIndex) {
        int length = source.length();
        for (int i = stopIndex + 1; i < length && source.charAt(i) == '}'; ++i) {
            ++stopIndex;
        }
        return stopIndex;
    }

    private static SpanParseResult getErrorResult(short type) {
        if (type == 2) {
            return SpanParseResult.IGNORE_RESULT_2;
        }
        if (type == 4) {
            return SpanParseResult.IGNORE_RESULT_3;
        }
        return SpanParseResult.IGNORE_RESULT_1;
    }
}

