/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.thesaurus;

import java.util.List;
import net.fichotheque.importation.ThesaurusImport;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.importation.thesaurus.EditThesaurusImportBuilder;
import net.fichotheque.tools.importation.thesaurus.MergeThesaurusImportBuilder;
import net.fichotheque.tools.importation.thesaurus.MoveThesaurusImportBuilder;
import net.fichotheque.tools.importation.thesaurus.RemoveThesaurusImportBuilder;

public abstract class ThesaurusImportBuilder {
    private final Thesaurus thesaurus;
    private final Thesaurus destinationThesaurus;
    private final String type;

    protected ThesaurusImportBuilder(Thesaurus thesaurus, String type, Thesaurus destinationThesaurus) {
        this.thesaurus = thesaurus;
        this.destinationThesaurus = destinationThesaurus;
        this.type = type;
    }

    protected ThesaurusImportBuilder(Thesaurus thesaurus, String type) {
        this(thesaurus, type, null);
    }

    public Thesaurus getThesaurus() {
        return this.thesaurus;
    }

    public Thesaurus getDestinationThesaurus() {
        return this.destinationThesaurus;
    }

    public String getType() {
        return this.type;
    }

    protected abstract List<ThesaurusImport.MotcleImport> getMotcleImportList();

    public ThesaurusImport toThesaurusImport() {
        return new InternalThesaurusImport(this.thesaurus, this.type, this.destinationThesaurus, this.getMotcleImportList());
    }

    public static ThesaurusImportBuilder init(Thesaurus thesaurus, String type) {
        return ThesaurusImportBuilder.init(thesaurus, type, null);
    }

    public static ThesaurusImportBuilder init(Thesaurus thesaurus, String type, Thesaurus destinationThesaurus) {
        switch (type = ThesaurusImport.checkType(type)) {
            case "edit": {
                return new EditThesaurusImportBuilder(thesaurus);
            }
            case "remove": {
                return new RemoveThesaurusImportBuilder(thesaurus);
            }
            case "move": {
                return new MoveThesaurusImportBuilder(thesaurus, destinationThesaurus);
            }
            case "merge": {
                return new MergeThesaurusImportBuilder(thesaurus, destinationThesaurus);
            }
        }
        throw new IllegalStateException("Test done before");
    }

    private static class InternalThesaurusImport
    implements ThesaurusImport {
        private final Thesaurus thesaurus;
        private final Thesaurus destinationThesaurus;
        private final String type;
        private final List<ThesaurusImport.MotcleImport> motcleImportList;

        private InternalThesaurusImport(Thesaurus thesaurus, String type, Thesaurus destinationThesaurus, List<ThesaurusImport.MotcleImport> motcleImportList) {
            this.thesaurus = thesaurus;
            this.type = type;
            this.destinationThesaurus = destinationThesaurus;
            this.motcleImportList = motcleImportList;
        }

        @Override
        public Thesaurus getThesaurus() {
            return this.thesaurus;
        }

        @Override
        public Thesaurus getDestinationThesaurus() {
            return this.destinationThesaurus;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public List<ThesaurusImport.MotcleImport> getMotcleImportList() {
            return this.motcleImportList;
        }
    }
}

