/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format.parsers;

import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.format.FormatContext;
import net.fichotheque.format.FormatSource;
import net.fichotheque.format.formatters.FicheBlockFormatter;
import net.fichotheque.format.formatters.FicheItemFormatter;
import net.fichotheque.tools.format.DefaultPatternCatalog;
import net.fichotheque.tools.format.JsonParameters;
import net.fichotheque.tools.format.LangParameters;
import net.fichotheque.tools.format.catalogs.FicheItemFormatterCatalog;
import net.fichotheque.utils.FormatterUtils;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.format.FormatConstants;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionResolver;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.MessageHandler;

public final class FicheItemFormatterParser {
    private static final JsonParameters AMOUNT_DEFAULTJSONPARAMETERS = JsonParameters.build("type", "currency", "decimal", "long");
    private static final JsonParameters COUNTRY_DEFAULTJSONPARAMETERS = JsonParameters.build("type", "code");
    private static final JsonParameters DATE_DEFAULTJSONPARAMETERS = JsonParameters.build("type", "datetype", "code", "iso");
    private static final JsonParameters EMAIL_DEFAULTJSONPARAMETERS = JsonParameters.build("type", "address");
    private static final JsonParameters GEOPOINT_DEFAULTJSONPARAMETERS = JsonParameters.build("type", "lat", "lon");
    private static final JsonParameters IMAGE_DEFAULTJSONPARAMETERS = JsonParameters.build("type", "src");
    private static final JsonParameters ITEM_DEFAULTJSONPARAMETERS = JsonParameters.build("type", "value");
    private static final JsonParameters LANGUAGE_DEFAULTJSONPARAMETERS = JsonParameters.build("type", "code");
    private static final JsonParameters LINK_DEFAULTJSONPARAMETERS = JsonParameters.build("type", "href");
    private static final JsonParameters NUMBER_DEFAULTJSONPARAMETERS = JsonParameters.build("type", "code", "value");
    private static final JsonParameters PARA_DEFAULTJSONPARAMETERS = JsonParameters.build("type", "raw");
    private static final JsonParameters PERSON_DEFAULTJSONPARAMETERS = JsonParameters.build("type", "standard");

    private FicheItemFormatterParser() {
    }

    public static FicheItemFormatter parse(CorpusField corpusField, String pattern, FormatContext formatContext, MessageHandler messageHandler) {
        String ficheItemType = corpusField.getFicheItemType();
        if (pattern == null) {
            pattern = DefaultPatternCatalog.ficheItem(ficheItemType);
        }
        try {
            Object[] partArray = FormatterUtils.parsePattern(new CorpusFieldInstructionResolver(formatContext, corpusField), pattern);
            return new InternalFicheItemFormatter(partArray);
        }
        catch (ErrorMessageException fe) {
            messageHandler.addMessage("severe.format.pattern", fe.getErrorMessage());
            return null;
        }
    }

    public static FicheItemFormatter parse(String ficheItemType, String pattern, FormatContext formatContext, MessageHandler messageHandler) {
        if (pattern == null) {
            pattern = DefaultPatternCatalog.ficheItem(ficheItemType);
        }
        try {
            Object[] partArray = FormatterUtils.parsePattern(new ItemTypeInstructionResolver(formatContext, ficheItemType), pattern);
            return new InternalFicheItemFormatter(partArray);
        }
        catch (ErrorMessageException fe) {
            messageHandler.addMessage("severe.format.pattern", fe.getErrorMessage());
            return null;
        }
    }

    public static FicheItemFormatter resolveFicheItem(Instruction instruction, String ficheItemType, FormatContext formatContext, CorpusField corpusField) throws ErrorMessageException {
        Argument arg1 = (Argument)instruction.get(0);
        String key = arg1.getKey();
        if (key.equals("formsyntax")) {
            return FicheItemFormatterCatalog.FORMSYNTAX;
        }
        if (key.equals("json")) {
            JsonParameters jsonParameters = JsonParameters.fromInstruction(instruction, FicheItemFormatterParser.getDefaultJsonParameters(ficheItemType));
            LangParameters langParameters = LangParameters.fromInstruction(instruction, "langs");
            return new FicheItemFormatterCatalog.Json(jsonParameters, langParameters.getCustomLangContext());
        }
        switch (ficheItemType) {
            case "language": {
                switch (key) {
                    case "code": {
                        return FicheItemFormatterCatalog.LANGUAGE_CODE;
                    }
                    case "label": 
                    case "lib": {
                        return new FicheItemFormatterCatalog.LanguageLabel(LangParameters.fromInstruction(instruction, key));
                    }
                }
                return null;
            }
            case "country": {
                switch (key) {
                    case "code": {
                        return FicheItemFormatterCatalog.COUNTRY_CODE;
                    }
                    case "label": 
                    case "lib": {
                        return new FicheItemFormatterCatalog.CountryLabel(LangParameters.fromInstruction(instruction, key));
                    }
                }
                return null;
            }
            case "item": {
                switch (key) {
                    case "value": {
                        return FicheItemFormatterCatalog.ITEM;
                    }
                }
                return null;
            }
            case "para": {
                switch (key) {
                    case "raw": {
                        return FicheItemFormatterCatalog.PARA_RAW;
                    }
                    case "transformation": {
                        String transformationName = arg1.getValue();
                        FicheBlockFormatter ficheBlockFormatter = formatContext.getFicheBlockFormatter(transformationName, instruction.toOptionMap(1));
                        if (ficheBlockFormatter == null) {
                            throw new ErrorMessageException("_ error.unknown.template", transformationName);
                        }
                        return new FicheItemFormatterCatalog.ParaTransformation(ficheBlockFormatter);
                    }
                }
                return null;
            }
            case "geopoint": {
                switch (key) {
                    case "lat": {
                        return FicheItemFormatterCatalog.GEO_LAT;
                    }
                    case "latlabel": 
                    case "latlib": {
                        return new FicheItemFormatterCatalog.GeoLatLabel(LangParameters.fromInstruction(instruction, key));
                    }
                    case "lon": {
                        return FicheItemFormatterCatalog.GEO_LON;
                    }
                    case "lonlabel": 
                    case "lonlib": {
                        return new FicheItemFormatterCatalog.GeoLonLabel(LangParameters.fromInstruction(instruction, key));
                    }
                }
                return null;
            }
            case "link": {
                switch (key) {
                    case "href": {
                        String base = FicheItemFormatterParser.getBaseValue(instruction, corpusField);
                        if (base == null) {
                            return FicheItemFormatterCatalog.LINK_HREF;
                        }
                        return new FicheItemFormatterCatalog.LinkHref(base);
                    }
                    case "title": {
                        return FicheItemFormatterCatalog.LINK_TITLE;
                    }
                    case "comment": {
                        return FicheItemFormatterCatalog.LINK_COMMENT;
                    }
                }
                return null;
            }
            case "image": {
                switch (key) {
                    case "src": {
                        String base = FicheItemFormatterParser.getBaseValue(instruction, corpusField);
                        if (base == null) {
                            return FicheItemFormatterCatalog.IMAGE_SRC;
                        }
                        return new FicheItemFormatterCatalog.ImageSrc(FicheItemFormatterParser.getBaseValue(instruction, corpusField));
                    }
                    case "alt": {
                        return FicheItemFormatterCatalog.IMAGE_ALT;
                    }
                    case "title": {
                        return FicheItemFormatterCatalog.IMAGE_TITLE;
                    }
                }
                return null;
            }
            case "email": {
                switch (key) {
                    case "complete": 
                    case "value": {
                        return FicheItemFormatterCatalog.EMAIL_COMPLETE;
                    }
                    case "address": 
                    case "addr": {
                        return FicheItemFormatterCatalog.EMAIL_ADDRESS;
                    }
                    case "name": {
                        return FicheItemFormatterCatalog.EMAIL_NAME;
                    }
                }
                return null;
            }
            case "number": {
                switch (key) {
                    case "code": {
                        return FicheItemFormatterCatalog.NUMBER_CODE;
                    }
                    case "label": 
                    case "lib": {
                        return new FicheItemFormatterCatalog.NumberLabel(LangParameters.fromInstruction(instruction, key));
                    }
                }
                return null;
            }
            case "amount": {
                switch (key) {
                    case "code": {
                        return FicheItemFormatterCatalog.AMOUNT_CODE;
                    }
                    case "currency": 
                    case "cur": {
                        return FicheItemFormatterCatalog.AMOUNT_CURRENCY;
                    }
                    case "label": 
                    case "lib": {
                        return new FicheItemFormatterCatalog.AmountLabel(LangParameters.fromInstruction(instruction, key), FicheItemFormatterParser.isForceSubunit(instruction));
                    }
                    case "decimal": 
                    case "value": {
                        return FicheItemFormatterCatalog.AMOUNT_DECIMAL;
                    }
                    case "long": {
                        return FicheItemFormatterCatalog.AMOUNT_MONEYLONG;
                    }
                }
                return null;
            }
            case "date": {
                switch (key) {
                    case "code": {
                        return FicheItemFormatterCatalog.DATE_CODE;
                    }
                    case "iso": {
                        return FicheItemFormatterCatalog.DATE_ISO;
                    }
                    case "lastday": 
                    case "iso_last": {
                        return FicheItemFormatterCatalog.DATE_ISO_LAST;
                    }
                    case "year": 
                    case "a": {
                        return FicheItemFormatterCatalog.DATE_YEAR;
                    }
                    case "isomonth": 
                    case "a-m": {
                        return FicheItemFormatterCatalog.DATE_ISOMONTH;
                    }
                    case "lastmonth": 
                    case "a-m_last": {
                        return FicheItemFormatterCatalog.DATE_ISOMONTH_LAST;
                    }
                    case "label": 
                    case "lib": {
                        return new FicheItemFormatterCatalog.DateLabel(LangParameters.fromInstruction(instruction, key), FicheItemFormatterParser.getTruncateType(instruction), FicheItemFormatterParser.getFormatStyle(instruction));
                    }
                    case "monthlabel": 
                    case "lib_m": {
                        return new FicheItemFormatterCatalog.DateLabel(LangParameters.fromInstruction(instruction, key), "month", FicheItemFormatterParser.getFormatStyle(instruction));
                    }
                    case "pattern": {
                        String value = arg1.getValue();
                        LangParameters langParameters = null;
                        if (instruction.hasArgument("lang")) {
                            langParameters = LangParameters.fromInstruction(instruction, "lang");
                        }
                        if (value == null) {
                            return new FicheItemFormatterCatalog.DatePattern(DateTimeFormatter.BASIC_ISO_DATE, langParameters);
                        }
                        try {
                            return new FicheItemFormatterCatalog.DatePattern(DateTimeFormatter.ofPattern(value), langParameters);
                        }
                        catch (IllegalArgumentException iae) {
                            throw new ErrorMessageException("_ error.wrong.pattern", value);
                        }
                    }
                }
                return null;
            }
            case "person": {
                switch (key) {
                    case "code": {
                        return FicheItemFormatterCatalog.PERSON_CODE;
                    }
                    case "sphere": {
                        return FicheItemFormatterCatalog.PERSON_SPHERE;
                    }
                    case "login": {
                        return FicheItemFormatterCatalog.PERSON_LOGIN;
                    }
                    case "standard": 
                    case "normal": {
                        return FicheItemFormatterCatalog.PERSON_STANDARD;
                    }
                    case "directory": 
                    case "annu": {
                        return FicheItemFormatterCatalog.PERSON_DIRECTORY;
                    }
                    case "updirectory": 
                    case "annu_up": {
                        return FicheItemFormatterCatalog.PERSON_UPDIRECTORY;
                    }
                    case "biblio": {
                        return FicheItemFormatterCatalog.PERSON_BIBLIO;
                    }
                    case "upbiblio": 
                    case "biblio_up": {
                        return FicheItemFormatterCatalog.PERSON_UPBIBLIO;
                    }
                    case "surname": 
                    case "nom": {
                        return FicheItemFormatterCatalog.PERSON_SURNAME;
                    }
                    case "upsurname": 
                    case "nom_up": {
                        return FicheItemFormatterCatalog.PERSON_UPSURNAME;
                    }
                    case "forename": 
                    case "prenom": {
                        return FicheItemFormatterCatalog.PERSON_FORENAME;
                    }
                    case "nonlatin": 
                    case "original": {
                        return FicheItemFormatterCatalog.PERSON_NONLATIN;
                    }
                    case "surnamefirst": 
                    case "nomavant": {
                        return FicheItemFormatterCatalog.PERSON_SURNAMEFIRST;
                    }
                    case "organism": 
                    case "organisme": {
                        return FicheItemFormatterCatalog.PERSON_ORGANISM;
                    }
                }
                return null;
            }
        }
        throw new SwitchException("ficheItemType = " + ficheItemType);
    }

    private static JsonParameters getDefaultJsonParameters(String ficheItemType) {
        switch (ficheItemType) {
            case "amount": {
                return AMOUNT_DEFAULTJSONPARAMETERS;
            }
            case "country": {
                return COUNTRY_DEFAULTJSONPARAMETERS;
            }
            case "date": {
                return DATE_DEFAULTJSONPARAMETERS;
            }
            case "email": {
                return EMAIL_DEFAULTJSONPARAMETERS;
            }
            case "geopoint": {
                return GEOPOINT_DEFAULTJSONPARAMETERS;
            }
            case "language": {
                return LANGUAGE_DEFAULTJSONPARAMETERS;
            }
            case "link": {
                return LINK_DEFAULTJSONPARAMETERS;
            }
            case "image": {
                return IMAGE_DEFAULTJSONPARAMETERS;
            }
            case "item": {
                return ITEM_DEFAULTJSONPARAMETERS;
            }
            case "number": {
                return NUMBER_DEFAULTJSONPARAMETERS;
            }
            case "para": {
                return PARA_DEFAULTJSONPARAMETERS;
            }
            case "person": {
                return PERSON_DEFAULTJSONPARAMETERS;
            }
        }
        throw new SwitchException("ficheItemType = " + ficheItemType);
    }

    private static String getBaseValue(Instruction instruction, CorpusField corpusField) {
        String baseValue = instruction.getArgumentValue("base");
        if (baseValue != null && !baseValue.isEmpty()) {
            return baseValue;
        }
        if (corpusField == null) {
            return null;
        }
        String defaultBase = corpusField.getStringOption("baseUrl");
        if (defaultBase != null) {
            return defaultBase;
        }
        return null;
    }

    private static FormatStyle getFormatStyle(Instruction instruction) {
        String dateStyle = instruction.getArgumentValue("datestyle");
        FormatStyle formatStyle = null;
        if (dateStyle != null) {
            formatStyle = FormatConstants.getMatchingFormatStyle(dateStyle);
        }
        if (formatStyle != null) {
            return formatStyle;
        }
        return FormatStyle.LONG;
    }

    private static String getTruncateType(Instruction instruction) {
        String truncateType = instruction.getArgumentValue("truncate");
        if (truncateType == null || truncateType.isEmpty()) {
            return "day";
        }
        return truncateType;
    }

    private static boolean isForceSubunit(Instruction instruction) {
        String subunitValue = instruction.getArgumentValue("subunit");
        if (subunitValue == null) {
            return false;
        }
        return subunitValue.isEmpty() || subunitValue.equals("force");
    }

    private static class CorpusFieldInstructionResolver
    implements InstructionResolver {
        private final FormatContext formatContext;
        private final CorpusField corpusField;

        private CorpusFieldInstructionResolver(FormatContext formatContext, CorpusField corpusField) {
            this.formatContext = formatContext;
            this.corpusField = corpusField;
        }

        @Override
        public Object resolve(Instruction instruction) throws ErrorMessageException {
            Object formatter;
            InstructionResolver resolver = this.formatContext.getInstructionResolverProvider().getInstructionResolver(FicheItemFormatter.class, this.corpusField);
            if (resolver != null && (formatter = resolver.resolve(instruction)) != null) {
                return formatter;
            }
            return FicheItemFormatterParser.resolveFicheItem(instruction, this.corpusField.getFicheItemType(), this.formatContext, this.corpusField);
        }
    }

    private static class InternalFicheItemFormatter
    implements FicheItemFormatter {
        private final Object[] partArray;

        private InternalFicheItemFormatter(Object[] partArray) {
            this.partArray = partArray;
        }

        @Override
        public String formatFicheItem(FicheItem ficheItem, FormatSource formatSource) {
            StringBuilder buf = new StringBuilder();
            for (Object obj : this.partArray) {
                if (obj instanceof String) {
                    buf.append((String)obj);
                    continue;
                }
                FicheItemFormatter formatter = (FicheItemFormatter)obj;
                buf.append(formatter.formatFicheItem(ficheItem, formatSource));
            }
            return buf.toString();
        }
    }

    private static class ItemTypeInstructionResolver
    implements InstructionResolver {
        private final FormatContext formatContext;
        private final String ficheItemType;

        private ItemTypeInstructionResolver(FormatContext formatContext, String ficheItemType) {
            this.formatContext = formatContext;
            this.ficheItemType = ficheItemType;
        }

        @Override
        public Object resolve(Instruction instruction) throws ErrorMessageException {
            Object formatter;
            InstructionResolver resolver = this.formatContext.getInstructionResolverProvider().getInstructionResolver(FicheItemFormatter.class, this.ficheItemType);
            if (resolver != null && (formatter = resolver.resolve(instruction)) != null) {
                return formatter;
            }
            return FicheItemFormatterParser.resolveFicheItem(instruction, this.ficheItemType, this.formatContext, null);
        }
    }
}

