/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.format;

import java.time.format.FormatStyle;
import java.util.HashSet;
import java.util.Set;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.format.FormatConstants;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.json.PropertyEligibility;
import net.mapeadores.util.text.StringUtils;

public class JsonParameters {
    private final InternalPropertyEligibility internalPropertyEligibility = new InternalPropertyEligibility();
    private final Set<String> propertyNameSet;
    private final String cellConverterName;
    private final FormatStyle formatStyle;

    public JsonParameters(Set<String> propertyNameSet, String cellConverterName, FormatStyle formatStyle) {
        this.propertyNameSet = propertyNameSet;
        this.cellConverterName = cellConverterName;
        this.formatStyle = formatStyle;
    }

    public PropertyEligibility getPropertyEligibility() {
        return this.internalPropertyEligibility;
    }

    @Nullable
    public String getCellConverterName() {
        return this.cellConverterName;
    }

    @Nullable
    public FormatStyle getFormatStyle() {
        return this.formatStyle;
    }

    public static JsonParameters fromInstruction(Instruction instruction, JsonParameters defaultJsonParameters) {
        HashSet<String> propertyNameSet = new HashSet<String>(defaultJsonParameters.propertyNameSet);
        String cellConverterName = defaultJsonParameters.getCellConverterName();
        FormatStyle formatStyle = defaultJsonParameters.getFormatStyle();
        block11: for (Argument argument : instruction) {
            String key = argument.getKey();
            String value = argument.getNotNullValue();
            switch (key) {
                case "include": {
                    String[] tokens;
                    for (String token : tokens = StringUtils.getTechnicalTokens(value, true)) {
                        if (token.startsWith("-")) {
                            propertyNameSet.remove(token.substring(1));
                            continue;
                        }
                        propertyNameSet.add(token);
                    }
                    continue block11;
                }
                case "properties": 
                case "cells": {
                    if (value.isEmpty()) break;
                    cellConverterName = value;
                    break;
                }
                case "datestyle": {
                    formatStyle = FormatConstants.getMatchingFormatStyle(value);
                }
            }
        }
        return new JsonParameters(propertyNameSet, cellConverterName, formatStyle);
    }

    public static JsonParameters build(String ... propertyNames) {
        HashSet<String> propertyNameSet = new HashSet<String>();
        for (String propertyName : propertyNames) {
            propertyNameSet.add(propertyName);
        }
        return new JsonParameters(propertyNameSet, null, null);
    }

    private class InternalPropertyEligibility
    implements PropertyEligibility {
        private InternalPropertyEligibility() {
        }

        @Override
        public boolean includeProperty(String propertyName) {
            if (propertyName.equals("properties")) {
                return JsonParameters.this.cellConverterName != null;
            }
            return JsonParameters.this.propertyNameSet.contains(propertyName);
        }
    }
}

