/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.transformation;

import net.fichotheque.exportation.transformation.TemplateContentDescription;
import net.fichotheque.exportation.transformation.TemplateKey;
import net.mapeadores.util.logging.LineLogs;
import net.mapeadores.util.logging.LineLogsBuilder;
import net.mapeadores.util.logging.LineMessage;
import net.mapeadores.util.logging.LineMessageHandler;

public class TemplateContentDescriptionBuilder
implements LineMessageHandler {
    private final LineLogsBuilder lineLogsBuilder = new LineLogsBuilder();
    private final TemplateKey templateKey;
    private final String path;
    private final String type;
    private boolean mandatory;
    private String state = "ok";

    public TemplateContentDescriptionBuilder(TemplateKey templateKey, String path, String type) {
        this.templateKey = templateKey;
        this.path = path;
        this.type = type;
    }

    @Override
    public void addMessage(LineMessage message) {
        this.state = "xml_error";
        this.lineLogsBuilder.addMessage(message);
    }

    public TemplateContentDescriptionBuilder setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
        return this;
    }

    public TemplateContentDescription toTemplateContentDescription() {
        return new InternalTemplateContentDescription(this.templateKey, this.path, this.type, this.mandatory, this.state, this.lineLogsBuilder.toLineLogs());
    }

    public static TemplateContentDescriptionBuilder init(TemplateKey templateKey, String path, String type) {
        return new TemplateContentDescriptionBuilder(templateKey, path, type);
    }

    private static class InternalTemplateContentDescription
    implements TemplateContentDescription {
        private final TemplateKey templateKey;
        private final String path;
        private final String type;
        private final boolean mandatory;
        private final String state;
        private final LineLogs lineLogs;

        private InternalTemplateContentDescription(TemplateKey templateKey, String path, String type, boolean mandatory, String state, LineLogs lineLogs) {
            this.templateKey = templateKey;
            this.path = path;
            this.type = type;
            this.mandatory = mandatory;
            this.state = state;
            this.lineLogs = lineLogs;
        }

        @Override
        public TemplateKey getTemplateKey() {
            return this.templateKey;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public boolean isMandatory() {
            return this.mandatory;
        }

        @Override
        public String getState() {
            return this.state;
        }

        @Override
        public LineLogs getLineLogs() {
            return this.lineLogs;
        }
    }
}

