/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.table;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.fichotheque.SubsetKey;
import net.fichotheque.exportation.table.ColDef;
import net.mapeadores.opendocument.io.OdXML;
import net.mapeadores.util.xml.XMLWriter;

public class NamedRangeHandler {
    private static final int MAX = 702;
    private SubsetKey currentSubsetKey;
    private String tableName;
    private final List<NamedRange> namedRangeList = new ArrayList<NamedRange>();

    public void setCurrentTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setCurrentSubset(SubsetKey subsetKey) {
        this.currentSubsetKey = subsetKey;
    }

    public void addColumnSum(int rowNumber, int colIndex, ColDef colDef) {
        if (colIndex >= 702) {
            return;
        }
        String name = "columnsum_" + this.currentSubsetKey + "_" + colDef.getColName();
        StringBuilder addressBuf = new StringBuilder();
        addressBuf.append("$'");
        int length = this.tableName.length();
        for (int i = 0; i < length; ++i) {
            char carac = this.tableName.charAt(i);
            if (carac == '\'') {
                addressBuf.append("''");
                continue;
            }
            addressBuf.append(carac);
        }
        addressBuf.append("'.$");
        addressBuf.append(OdXML.toLetter(colIndex + 1));
        addressBuf.append("$");
        addressBuf.append(rowNumber);
        this.namedRangeList.add(new NamedRange(name, addressBuf.toString()));
    }

    public void toXML(XMLWriter xmlWriter) throws IOException {
        if (this.namedRangeList.isEmpty()) {
            return;
        }
        OdXML.openNamedExpressions(xmlWriter);
        for (NamedRange namedRange : this.namedRangeList) {
            namedRange.toXML(xmlWriter);
        }
        OdXML.closeNamedExpressions(xmlWriter);
    }

    private static class NamedRange {
        private final String name;
        private final String address;

        private NamedRange(String name, String address) {
            this.name = name;
            this.address = address;
        }

        private void toXML(XMLWriter xmlWriter) throws IOException {
            OdXML.addNamedRange(xmlWriter, this.name, this.address);
        }
    }
}

