/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.exportation.balayage.dom;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DocumentFragmentHolderBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IncludeCatalogDOMReader {
    private static final short RESOLVED_ALL = 1;
    private static final short RESOLVED_SOME = 2;
    private static final short RESOLVED_NONE = 3;
    private final DocumentFragmentHolderBuilder documentFragmentHolderBuilder;
    private final MessageHandler messageHandler;

    public IncludeCatalogDOMReader(DocumentFragmentHolderBuilder documentFragmentHolderBuilder, MessageHandler messageHandler) {
        this.documentFragmentHolderBuilder = documentFragmentHolderBuilder;
        this.messageHandler = messageHandler;
    }

    public IncludeCatalogDOMReader read(Element element) {
        CatalogBuffer catalogBuffer = new CatalogBuffer();
        DOMUtils.readChildren(element, new RootConsumer(catalogBuffer));
        catalogBuffer.flush(this.documentFragmentHolderBuilder);
        return this;
    }

    public static IncludeCatalogDOMReader init(DocumentFragmentHolderBuilder documentFragmentHolderBuilder, MessageHandler messageHandler) {
        return new IncludeCatalogDOMReader(documentFragmentHolderBuilder, messageHandler);
    }

    private static class CatalogBuffer {
        private final Document document = DOMUtils.newDocument();
        private final Map<String, DocumentFragment> finalFragmentMap = new HashMap<String, DocumentFragment>();
        private final Map<String, FragmentBuffer> unresolvedFragmentMap = new HashMap<String, FragmentBuffer>();

        private CatalogBuffer() {
        }

        private void flush(DocumentFragmentHolderBuilder documentFragmentHolderBuilder) {
            this.resolve();
            for (Map.Entry<String, DocumentFragment> entry : this.finalFragmentMap.entrySet()) {
                documentFragmentHolderBuilder.put(entry.getKey(), entry.getValue());
            }
        }

        private void resolve() {
            if (this.unresolvedFragmentMap.isEmpty()) {
                return;
            }
            boolean oneDone = false;
            Iterator<FragmentBuffer> it = this.unresolvedFragmentMap.values().iterator();
            while (it.hasNext()) {
                FragmentBuffer documentFragmentBuilder = it.next();
                short result = documentFragmentBuilder.resolve(this.finalFragmentMap);
                switch (result) {
                    case 1: {
                        it.remove();
                        oneDone = true;
                        break;
                    }
                    case 2: {
                        oneDone = true;
                        break;
                    }
                }
            }
            if (oneDone) {
                if (this.unresolvedFragmentMap.isEmpty()) {
                    return;
                }
            } else {
                return;
            }
            this.resolve();
        }

        private void addIncludeFragment(String key, NodeList nodeList) {
            if (this.finalFragmentMap.containsKey(key)) {
                this.finalFragmentMap.remove(key);
            }
            if (this.unresolvedFragmentMap.containsKey(key)) {
                this.unresolvedFragmentMap.remove(key);
            }
            DocumentFragment documentFragment = this.document.createDocumentFragment();
            int count = nodeList.getLength();
            for (int i = 0; i < count; ++i) {
                Node node = nodeList.item(i);
                Node importNode = this.document.importNode(node, true);
                documentFragment.appendChild(importNode);
            }
            FragmentBuffer fragmentBuffer = new FragmentBuffer(key, documentFragment);
            if (fragmentBuffer.hasIncludeElement()) {
                this.unresolvedFragmentMap.put(key, fragmentBuffer);
            } else {
                this.finalFragmentMap.put(key, documentFragment);
            }
        }
    }

    private class RootConsumer
    implements Consumer<Element> {
        private final CatalogBuffer catalogBuffer;

        private RootConsumer(CatalogBuffer fragmentBuffer) {
            this.catalogBuffer = fragmentBuffer;
        }

        @Override
        public void accept(Element element) {
            String tagName;
            switch (tagName = element.getTagName()) {
                case "fragment": {
                    String key = element.getAttribute("key");
                    this.catalogBuffer.addIncludeFragment(key, element.getChildNodes());
                }
            }
        }
    }

    private static class FragmentBuffer {
        private final String key;
        private final DocumentFragment documentFragment;
        private final List<Element> elementList = new LinkedList<Element>();

        private FragmentBuffer(String key, DocumentFragment documentFragment) {
            this.key = key;
            this.documentFragment = documentFragment;
            NodeList list = documentFragment.getChildNodes();
            int count = list.getLength();
            for (int i = 0; i < count; ++i) {
                Node node = list.item(i);
                if (!(node instanceof Element)) continue;
                Element element = (Element)node;
                if (element.getTagName().equals("include")) {
                    this.addIncludeElement(element);
                    continue;
                }
                NodeList includeChildren = element.getElementsByTagName("include");
                int includeCount = includeChildren.getLength();
                for (int j = 0; j < includeCount; ++j) {
                    this.addIncludeElement((Element)includeChildren.item(j));
                }
            }
        }

        private short resolve(Map<String, DocumentFragment> finalFragmentMap) {
            boolean oneDone = false;
            Iterator<Element> it = this.elementList.iterator();
            while (it.hasNext()) {
                Element element = it.next();
                String fragmentKey = element.getAttribute("fragment-key");
                DocumentFragment finalFragment = finalFragmentMap.get(fragmentKey);
                if (finalFragment == null) continue;
                finalFragment = (DocumentFragment)finalFragment.cloneNode(true);
                element.getParentNode().replaceChild(finalFragment, element);
                oneDone = true;
                it.remove();
            }
            if (oneDone) {
                if (this.elementList.isEmpty()) {
                    finalFragmentMap.put(this.key, this.documentFragment);
                    return 1;
                }
                return 2;
            }
            return 3;
        }

        private boolean hasIncludeElement() {
            return this.elementList.size() > 0;
        }

        private void addIncludeElement(Element element) {
            String fragmentKey;
            NodeList includeChildren = element.getElementsByTagName("include");
            if (includeChildren.getLength() == 0 && (fragmentKey = element.getAttribute("fragment-key")).length() > 0) {
                this.elementList.add(element);
            }
        }
    }
}

