/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.corpus;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.DateItem;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.LanguageItem;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.junction.Junctions;
import net.fichotheque.junction.Liaison;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.tools.corpus.FicheDistribution;
import net.fichotheque.tools.corpus.GroupingKey;
import net.fichotheque.utils.FicheUtils;
import net.fichotheque.utils.JunctionUtils;
import net.mapeadores.util.localisation.Lang;

public class FicheDistributionEngine {
    private static final Lang UND = Lang.build("und");
    private final Fichotheque fichotheque;
    private final Map<IncludeKey, CorpusInfo> corpusInfoMap = new LinkedHashMap<IncludeKey, CorpusInfo>();

    public FicheDistributionEngine(Fichotheque fichotheque) {
        this.fichotheque = fichotheque;
    }

    public boolean isEmpty() {
        return this.corpusInfoMap.isEmpty();
    }

    public boolean addCorpus(IncludeKey corpusIncludeKey, String fixed, GroupingKey groupingFieldKey) {
        SubsetKey subsetKey = corpusIncludeKey.getSubsetKey();
        if (!subsetKey.isCorpusSubset()) {
            return false;
        }
        Corpus corpus = (Corpus)this.fichotheque.getSubset(subsetKey);
        if (corpus == null) {
            return false;
        }
        this.corpusInfoMap.put(corpusIncludeKey, new CorpusInfo(corpusIncludeKey, corpus, fixed, groupingFieldKey));
        return true;
    }

    public boolean addCorpus(IncludeKey corpusIncludeKey, IncludeKey thesaurusIncludeKey, GroupingKey groupingFieldKey) {
        SubsetKey corpusKey = corpusIncludeKey.getSubsetKey();
        if (!corpusKey.isCorpusSubset()) {
            return false;
        }
        Corpus corpus = (Corpus)this.fichotheque.getSubset(corpusKey);
        if (corpus == null) {
            return false;
        }
        SubsetKey thesaurusKey = thesaurusIncludeKey.getSubsetKey();
        if (!thesaurusKey.isThesaurusSubset()) {
            return false;
        }
        Thesaurus thesaurus = (Thesaurus)this.fichotheque.getSubset(thesaurusKey);
        if (thesaurus == null) {
            return false;
        }
        ThesaurusInfo thesaurusInfo = new ThesaurusInfo(thesaurusIncludeKey, thesaurus);
        this.corpusInfoMap.put(corpusIncludeKey, new CorpusInfo(corpusIncludeKey, corpus, thesaurusInfo, groupingFieldKey));
        return true;
    }

    public FicheDistribution run(SubsetItem subsetItem, Predicate<SubsetItem> predicate) {
        FicheDistribution ficheDistribution = new FicheDistribution();
        for (CorpusInfo corpusInfo : this.corpusInfoMap.values()) {
            Junctions junctions = this.fichotheque.getJunctions(subsetItem, corpusInfo.getCorpus());
            IncludeKey includeKey = corpusInfo.getIncludeKey();
            Collection<Liaison> liaisons = JunctionUtils.filter(junctions, includeKey, predicate);
            if (corpusInfo.getFixed() != null) {
                this.addFixed(ficheDistribution, liaisons, corpusInfo.getFixed(), corpusInfo.getGroupingKey());
                continue;
            }
            this.addThesaurus(ficheDistribution, liaisons, corpusInfo.getThesaurusInfo(), corpusInfo.getGroupingKey());
        }
        return ficheDistribution;
    }

    private void addFixed(FicheDistribution ficheDistribution, Collection<Liaison> liaisons, String fixedEntryName, GroupingKey groupingKey) {
        for (Liaison liaison : liaisons) {
            FicheMeta ficheMeta = (FicheMeta)liaison.getSubsetItem();
            Object date = this.getGroupingObject(ficheMeta, groupingKey);
            ficheDistribution.addFiche(fixedEntryName, ficheMeta, date);
        }
    }

    private void addThesaurus(FicheDistribution ficheDistribution, Collection<Liaison> liaisons, ThesaurusInfo thesaurusInfo, GroupingKey groupingKey) {
        Thesaurus thesaurus = thesaurusInfo.getThesaurus();
        IncludeKey includeKey = thesaurusInfo.getIncludeKey();
        for (Liaison liaison : liaisons) {
            FicheMeta ficheMeta = (FicheMeta)liaison.getSubsetItem();
            Object groupingObject = this.getGroupingObject(ficheMeta, groupingKey);
            Junctions junctions = this.fichotheque.getJunctions(ficheMeta, thesaurus);
            Collection<Liaison> motcleLiaisons = JunctionUtils.filter(junctions, includeKey);
            if (motcleLiaisons.isEmpty()) {
                ficheDistribution.addFiche("", ficheMeta, groupingObject);
                continue;
            }
            for (Liaison motcleLiaison : motcleLiaisons) {
                Motcle motcle = (Motcle)motcleLiaison.getSubsetItem();
                String idalpha = motcle.getIdalpha();
                if (idalpha == null) {
                    idalpha = "_" + motcle.getId();
                }
                ficheDistribution.addFiche(idalpha, ficheMeta, groupingObject);
            }
        }
    }

    private Object getGroupingObject(FicheMeta ficheMeta, GroupingKey groupingKey) {
        if (groupingKey.isCreationDate()) {
            return ficheMeta.getCreationDate();
        }
        if (groupingKey.isLang()) {
            Lang lang = ficheMeta.getLang();
            if (lang == null) {
                lang = UND;
            }
            return lang;
        }
        Object obj = FicheUtils.getValue(ficheMeta, groupingKey.getFieldKey());
        if (obj != null) {
            if (obj instanceof FicheItem) {
                return this.getGroupingObject((FicheItem)obj);
            }
            if (obj instanceof FicheItems) {
                return this.getGroupingObject((FicheItem)((FicheItems)obj).get(0));
            }
        }
        return null;
    }

    private Object getGroupingObject(FicheItem ficheItem) {
        if (ficheItem instanceof DateItem) {
            return ((DateItem)ficheItem).getDate();
        }
        if (ficheItem instanceof LanguageItem) {
            return ((LanguageItem)ficheItem).getLang();
        }
        return null;
    }

    private class CorpusInfo {
        private final IncludeKey includeKey;
        private final Corpus corpus;
        private final String fixed;
        private final ThesaurusInfo thesaurusInfo;
        private final GroupingKey groupingKey;

        private CorpusInfo(IncludeKey includeKey, Corpus corpus, String fixed, GroupingKey groupingKey) {
            this.includeKey = includeKey;
            this.corpus = corpus;
            this.fixed = fixed;
            this.thesaurusInfo = null;
            this.groupingKey = groupingKey;
        }

        private CorpusInfo(IncludeKey includeKey, Corpus corpus, ThesaurusInfo thesaurusInfo, GroupingKey groupingKey) {
            this.includeKey = includeKey;
            this.corpus = corpus;
            this.fixed = null;
            this.thesaurusInfo = thesaurusInfo;
            this.groupingKey = groupingKey;
        }

        private IncludeKey getIncludeKey() {
            return this.includeKey;
        }

        private Corpus getCorpus() {
            return this.corpus;
        }

        private String getFixed() {
            return this.fixed;
        }

        private ThesaurusInfo getThesaurusInfo() {
            return this.thesaurusInfo;
        }

        private GroupingKey getGroupingKey() {
            return this.groupingKey;
        }
    }

    private class ThesaurusInfo {
        private final IncludeKey includeKey;
        private final Thesaurus thesaurus;

        private ThesaurusInfo(IncludeKey includeKey, Thesaurus thesaurus) {
            this.includeKey = includeKey;
            this.thesaurus = thesaurus;
        }

        private IncludeKey getIncludeKey() {
            return this.includeKey;
        }

        private Thesaurus getThesaurus() {
            return this.thesaurus;
        }
    }
}

