/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.impl.JunctionImpl;
import net.fichotheque.junction.Junction;
import net.fichotheque.junction.Junctions;
import net.fichotheque.utils.JunctionUtils;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.attr.AttributesCache;

abstract class AbstractSubsetItem
implements SubsetItem {
    private final Map<SubsetKey, InternalJunctions> junctionsMap = new HashMap<SubsetKey, InternalJunctions>();
    private AttributesCache attributesCache = null;

    AbstractSubsetItem() {
    }

    @Override
    public Attributes getAttributes() {
        if (this.attributesCache == null) {
            return AttributeUtils.EMPTY_ATTRIBUTES;
        }
        return this.attributesCache.getAttributes();
    }

    protected synchronized boolean innerRemoveAttribute(AttributeKey attributeKey) {
        if (this.attributesCache == null) {
            return false;
        }
        boolean done = this.attributesCache.removeAttribute(attributeKey);
        if (done) {
            this.fireAttributeChange();
        }
        return done;
    }

    protected synchronized boolean innerPutAttribute(Attribute attribute) {
        boolean done;
        if (this.attributesCache == null) {
            this.attributesCache = new AttributesCache();
        }
        if (done = this.attributesCache.putAttribute(attribute)) {
            this.fireAttributeChange();
        }
        return done;
    }

    void fireAttributeChange() {
    }

    @Override
    public Junctions getJunctions(Subset subset) {
        InternalJunctions junctions = this.junctionsMap.get(subset.getSubsetKey());
        if (junctions == null) {
            return JunctionUtils.EMPTY_JUNCTIONS;
        }
        return junctions.getCache();
    }

    void link(SubsetItem otherSubsetItem, JunctionImpl junctionImpl) {
        SubsetKey otherSubsetKey = otherSubsetItem.getSubsetKey();
        InternalJunctions junctions = this.junctionsMap.get(otherSubsetKey);
        if (junctions == null) {
            junctions = new InternalJunctions();
            this.junctionsMap.put(otherSubsetKey, junctions);
        }
        junctions.add(otherSubsetItem, junctionImpl);
    }

    void unlink(SubsetItem otherSubsetItem, JunctionImpl junctionImpl) {
        SubsetKey otherSubsetKey = otherSubsetItem.getSubsetKey();
        InternalJunctions junctions = this.junctionsMap.get(otherSubsetKey);
        if (junctions != null) {
            junctions.remove(junctionImpl);
        }
    }

    boolean hasJunction() {
        if (this.junctionsMap.isEmpty()) {
            return false;
        }
        for (InternalJunctions junctions : this.junctionsMap.values()) {
            if (junctions.entryList.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private static class InternalJunctions {
        private final List<Junctions.Entry> entryList = new ArrayList<Junctions.Entry>();
        private Junctions cache;

        private InternalJunctions() {
        }

        private Junctions getCache() {
            Junctions result = this.cache;
            if (result == null) {
                result = this.initCache();
            }
            return result;
        }

        private synchronized void add(SubsetItem subsetItem, Junction junction) {
            this.entryList.add(JunctionUtils.toEntry(subsetItem, junction));
            this.clearCache();
        }

        private synchronized void remove(JunctionImpl junctionImpl) {
            int size = this.entryList.size();
            for (int i = 0; i < size; ++i) {
                if (!this.entryList.get(i).getJunction().equals(junctionImpl)) continue;
                this.entryList.remove(i);
                this.clearCache();
                break;
            }
        }

        private void clearCache() {
            this.cache = null;
        }

        private synchronized Junctions initCache() {
            Junctions newCache;
            if (this.cache != null) {
                return this.cache;
            }
            this.cache = newCache = JunctionUtils.toJunctions(this.entryList);
            return newCache;
        }
    }
}

