/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.extraction.def;

import java.text.ParseException;

public class TagNameInfo {
    public static final short DEFAULT_TYPE = 1;
    public static final short NULL_TYPE = 2;
    public static final short CUSTOM_TYPE = 3;
    public static final TagNameInfo DEFAULT = new TagNameInfo(1);
    public static final TagNameInfo NULL = new TagNameInfo(2);
    private final short type;
    private final String customTagName;

    private TagNameInfo(short type) {
        this.type = type;
        this.customTagName = null;
    }

    private TagNameInfo(String customTagName) {
        this.type = (short)3;
        this.customTagName = customTagName;
    }

    public short getType() {
        return this.type;
    }

    public String getCustomTagName() {
        return this.customTagName;
    }

    public static TagNameInfo parse(String tagName) throws ParseException {
        if (tagName == null) {
            return NULL;
        }
        if (tagName.isEmpty()) {
            return DEFAULT;
        }
        TagNameInfo.check(tagName);
        return new TagNameInfo(tagName);
    }

    private static void check(String s) throws ParseException {
        int charLength = s.length();
        for (int i = 0; i < charLength; ++i) {
            char carac = s.charAt(i);
            if (TagNameInfo.isCharacter(carac)) continue;
            if (i == 0) {
                throw new ParseException("wrong character: " + carac, i);
            }
            if (TagNameInfo.isNumber(carac)) continue;
            if (i == charLength - 1) {
                throw new ParseException("wrong character: " + carac, i);
            }
            if (TagNameInfo.isSpecialChar(carac)) continue;
            throw new ParseException("wrong character: " + carac, i);
        }
    }

    private static boolean isCharacter(char carac) {
        return carac >= 'a' && carac <= 'z' || carac >= 'A' && carac <= 'Z';
    }

    private static boolean isNumber(char carac) {
        return carac >= '0' && carac <= '9';
    }

    private static boolean isSpecialChar(char carac) {
        switch (carac) {
            case '-': 
            case '_': {
                return true;
            }
        }
        return false;
    }
}

