/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.corpus.fiche;

import java.io.Serializable;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.fiche.Atts;
import net.fichotheque.corpus.fiche.AttsImpl;
import net.fichotheque.corpus.fiche.ParagraphBlock;
import net.fichotheque.corpus.fiche.TextContent;
import net.fichotheque.corpus.fiche.TextContentBuilder;
import net.fichotheque.corpus.fiche.ZoneBlock;

public class Insert
implements ZoneBlock,
Serializable {
    private static final long serialVersionUID = 6L;
    public static final short IMAGE_TYPE = 1;
    public static final short LETTRINE_TYPE = 2;
    public static final short AUDIO_TYPE = 3;
    public static final short POSITION_UNDETERMINED = 0;
    public static final short POSITION_LEFT = 1;
    public static final short POSITION_RIGHT = 2;
    private final ParagraphBlock numero = new ParagraphBlock();
    private final ParagraphBlock legende = new ParagraphBlock();
    private short type;
    private int width = -1;
    private int height = -1;
    private String src = "";
    private String ref = "";
    private SubsetKey subsetKey = null;
    private int id = 0;
    private String albumDimName = null;
    private short position = 0;
    private final ParagraphBlock alt = new ParagraphBlock();
    private final ParagraphBlock credit = new ParagraphBlock();
    private AttsImpl attsImpl;

    public Insert(short type) {
        if (type < 1 && type > 2) {
            throw new IllegalArgumentException("wrong type value");
        }
        this.type = type;
        if (type == 2) {
            this.position = 1;
        }
    }

    public short getType() {
        return this.type;
    }

    public String getSrc() {
        return this.src;
    }

    public String getRef() {
        return this.ref;
    }

    public TextContent getAlt() {
        return this.alt;
    }

    public TextContentBuilder getAltBuilder() {
        return this.alt;
    }

    public TextContent getCredit() {
        return this.credit;
    }

    public TextContentBuilder getCreditBuilder() {
        return this.credit;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public short getPosition() {
        return this.position;
    }

    public void setWidth(int width) {
        this.width = width < 0 ? -1 : width;
    }

    public void setHeight(int height) {
        this.height = height < 0 ? -1 : height;
    }

    public void setPosition(short position) {
        if (this.type != 2) {
            return;
        }
        this.position = position != 2 ? (short)1 : (short)2;
    }

    public void setSrc(String src) {
        this.src = src == null ? "" : src;
    }

    public void setRef(String ref) {
        this.ref = ref == null ? "" : ref;
    }

    public void setSubsetItem(SubsetKey subsetKey, int id, String albumDimName) {
        this.subsetKey = subsetKey;
        this.id = id;
        this.albumDimName = albumDimName == null ? "" : albumDimName;
    }

    public SubsetKey getSubsetKey() {
        return this.subsetKey;
    }

    public int getId() {
        return this.id;
    }

    public String getAlbumDimName() {
        return this.albumDimName;
    }

    @Override
    public TextContent getNumero() {
        return this.numero;
    }

    @Override
    public TextContent getLegende() {
        return this.legende;
    }

    @Override
    public TextContentBuilder getNumeroBuilder() {
        return this.numero;
    }

    @Override
    public TextContentBuilder getLegendeBuilder() {
        return this.legende;
    }

    @Override
    public Atts getAtts() {
        return AttsImpl.check(this.attsImpl);
    }

    @Override
    public void putAtt(String name, String value) {
        this.attsImpl = AttsImpl.put(this.attsImpl, name, value);
    }

    public static String typeToString(short type) {
        switch (type) {
            case 1: {
                return "image";
            }
            case 2: {
                return "lettrine";
            }
            case 3: {
                return "audio";
            }
        }
        throw new IllegalArgumentException("wrong type value");
    }

    public static char typeToInitiale(short type) {
        switch (type) {
            case 1: {
                return 'i';
            }
            case 2: {
                return 'l';
            }
            case 3: {
                return 'a';
            }
        }
        throw new IllegalArgumentException("wrong type value");
    }

    public static String positionToString(short position) {
        switch (position) {
            case 1: {
                return "left";
            }
            case 2: {
                return "right";
            }
            case 0: {
                return "";
            }
        }
        throw new IllegalArgumentException("wrong position value");
    }

    public static char positionToInitiale(short position) {
        switch (position) {
            case 1: {
                return 'l';
            }
            case 2: {
                return 'r';
            }
            case 0: {
                return '0';
            }
        }
        throw new IllegalArgumentException("wrong position value");
    }

    public static short typeToShort(String typeString) {
        switch (typeString) {
            case "image": {
                return 1;
            }
            case "lettrine": {
                return 2;
            }
            case "audio": {
                return 3;
            }
        }
        throw new IllegalArgumentException("wrong type value");
    }

    public static short typeToShort(char initiale) {
        switch (initiale) {
            case 'i': {
                return 1;
            }
            case 'l': {
                return 2;
            }
            case 'a': {
                return 3;
            }
        }
        return 1;
    }

    public static short positionToShort(char initiale) {
        switch (initiale) {
            case 'r': {
                return 2;
            }
            case 'l': {
                return 1;
            }
        }
        return 0;
    }

    public static short positionToString(String typeString) {
        switch (typeString) {
            case "left": {
                return 1;
            }
            case "right": {
                return 2;
            }
        }
        return 0;
    }

    public static boolean isIllustrationType(short type) {
        switch (type) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDocumentType(short type) {
        switch (type) {
            case 3: {
                return true;
            }
        }
        return false;
    }
}

