/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.corpus.fiche;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.FicheBlocks;

class FicheBlocksImpl
extends AbstractList<FicheBlock>
implements FicheBlocks,
Serializable {
    private static final long serialVersionUID = 3L;
    private FicheBlock[] blocks = new FicheBlock[8];
    private int size = 0;

    FicheBlocksImpl() {
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public FicheBlock get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.blocks[index];
    }

    @Override
    public void clear() {
        Arrays.fill(this.blocks, null);
        this.size = 0;
    }

    @Override
    public boolean add(FicheBlock ficheBlock) {
        if (ficheBlock == null) {
            throw new NullPointerException();
        }
        if (!this.isValidFicheBlock(ficheBlock)) {
            return false;
        }
        this.checkLength();
        this.blocks[this.size] = ficheBlock;
        ++this.size;
        return true;
    }

    public boolean isValidFicheBlock(FicheBlock ficheBlock) {
        return true;
    }

    public void addAll(FicheBlocks ficheBlocks) {
        int othersize = ficheBlocks.size();
        this.checkLength(othersize);
        for (int i = 0; i < othersize; ++i) {
            FicheBlock ficheBlock = (FicheBlock)ficheBlocks.get(i);
            this.add(ficheBlock);
        }
    }

    private void checkLength(int addlength) {
        if (this.size + addlength >= this.blocks.length) {
            FicheBlock[] nv = new FicheBlock[this.size + addlength];
            System.arraycopy(this.blocks, 0, nv, 0, this.size);
            this.blocks = nv;
        }
    }

    private void checkLength() {
        if (this.size == this.blocks.length) {
            FicheBlock[] nv = new FicheBlock[this.size * 2];
            System.arraycopy(this.blocks, 0, nv, 0, this.size);
            this.blocks = nv;
        }
    }
}

