/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.xml.users;

import fr.exemole.bdfserver.api.users.BdfUserPrefs;
import java.io.IOException;
import java.util.Locale;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.utils.FichothequeXMLUtils;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangPreference;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class BdfUserPrefsXMLPart
extends XMLPart {
    public BdfUserPrefsXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
    }

    public void addPrefs(BdfUserPrefs bdfUserPrefs) throws IOException {
        this.openTag("user-prefs");
        this.appendLocalisationInfo(bdfUserPrefs);
        this.appendSelection(bdfUserPrefs);
        AttributeUtils.addAttributes(this, bdfUserPrefs.getAttributes());
        this.closeTag("user-prefs");
    }

    private void appendLocalisationInfo(BdfUserPrefs bdfUserPrefs) throws IOException {
        LangPreference customLangPreference;
        Locale customFormatLocale;
        Lang workingLang = bdfUserPrefs.getWorkingLang();
        if (workingLang != null) {
            this.addSimpleElement("lang", workingLang.toString());
        }
        if ((customFormatLocale = bdfUserPrefs.getCustomFormatLocale()) != null) {
            this.addSimpleElement("format-locale", Lang.toISOString(customFormatLocale));
        }
        if ((customLangPreference = bdfUserPrefs.getCustomLangPreference()) != null) {
            this.openTag("lang-preference");
            for (Lang lang : customLangPreference) {
                this.addSimpleElement("lang", lang.toString());
            }
            this.closeTag("lang-preference");
        }
    }

    private void appendSelection(BdfUserPrefs bdfUserPrefs) throws IOException {
        FicheQuery ficheQuery = bdfUserPrefs.getDefaultFicheQuery();
        if (ficheQuery != null) {
            this.openTag("selection");
            FichothequeXMLUtils.writeFicheQuery(this, ficheQuery);
            this.closeTag("selection");
        }
    }
}

