/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.storage;

import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.fichotheque.EditOrigin;
import net.fichotheque.history.HistoryUnit;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.io.FileUtils;
import net.mapeadores.util.io.IOUtils;
import org.w3c.dom.Document;

public class StorageFile {
    public static final String ENCODING = "UTF-8";
    private final String relativePath;
    private final File file;
    private final File backupFile;

    public StorageFile(String relativePath, File file, File backupFile) {
        if (file == null) {
            throw new IllegalArgumentException("file is null");
        }
        this.relativePath = relativePath;
        this.file = file;
        this.backupFile = backupFile;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public boolean exists() {
        return this.file.exists();
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    public boolean backupExist() {
        return this.backupFile != null && this.backupFile.exists();
    }

    public String getName() {
        return this.file.getName();
    }

    public File getFile() {
        return this.file;
    }

    public File getBackupFile() {
        return this.backupFile;
    }

    public String toURI() {
        return this.file.getPath();
    }

    public void delete() {
        this.backup();
        try {
            if (this.file.exists()) {
                FileUtils.forceDelete(this.file);
            }
        }
        catch (IOException ioe) {
            throw new BdfStorageException(this.file, (Throwable)ioe);
        }
    }

    public List<StorageFile> listFiles() {
        ArrayList<StorageFile> result = new ArrayList<StorageFile>();
        if (this.file.isDirectory()) {
            for (File f : this.file.listFiles()) {
                result.add(this.getSubStorageFile(f.getName()));
            }
        }
        return result;
    }

    public StorageFile getSubStorageFile(String path) {
        String subRelativePath = this.relativePath + File.separator + path;
        File subFile = new File(this.file, path);
        File subBackupFile = null;
        if (this.backupFile != null) {
            subBackupFile = new File(this.backupFile, path);
        }
        return new StorageFile(subRelativePath, subFile, subBackupFile);
    }

    public HistoryUnit getHistoryUnit() {
        return StorageUtils.getHistoryUnit(this.file, this.backupFile);
    }

    public List<String> readLines() {
        List<String> result;
        if (!this.file.exists()) {
            return null;
        }
        try (FileInputStream is = new FileInputStream(this.file);){
            result = IOUtils.readLines(is, ENCODING);
        }
        catch (IOException ioe) {
            if (!this.backupExist()) {
                throw new BdfStorageException(this.file, (Throwable)ioe);
            }
            try (FileInputStream is2 = new FileInputStream(this.backupFile);){
                result = IOUtils.readLines(is2, ENCODING);
            }
            catch (IOException ioe2) {
                throw new BdfStorageException(this.backupFile, (Throwable)ioe2);
            }
            this.restore();
        }
        return result;
    }

    public Document readDocument() {
        if (!this.file.exists()) {
            return null;
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docbuilder = null;
        Document document = null;
        try {
            docbuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new BdfStorageException(pce);
        }
        try (FileInputStream is = new FileInputStream(this.file);){
            document = docbuilder.parse(is);
        }
        catch (Exception e) {
            if (!this.backupExist()) {
                throw new BdfStorageException(this.file, (Throwable)e);
            }
            try (FileInputStream is2 = new FileInputStream(this.backupFile);){
                document = docbuilder.parse(is2);
            }
            catch (Exception e2) {
                throw new BdfStorageException(this.backupFile, (Throwable)e);
            }
            this.restore();
        }
        return document;
    }

    public Document readDocument(String versionName) {
        return StorageUtils.readDocument(this.file, this.backupFile, versionName);
    }

    public boolean restore() {
        if (this.backupExist()) {
            try {
                FileUtils.copyFile(this.backupFile, this.file);
            }
            catch (IOException ioe) {
                throw new BdfStorageException(this.file, (Throwable)ioe);
            }
            return true;
        }
        return false;
    }

    public BufferedWriter getWriter() throws IOException {
        return this.getWriter(true);
    }

    public BufferedWriter getWriter(boolean withBackup) throws IOException {
        this.testPath();
        if (withBackup) {
            this.backup();
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), ENCODING);
        BufferedWriter bufWriter = new BufferedWriter(writer);
        return bufWriter;
    }

    public BufferedWriter archiveAndGetWriter(@Nullable EditOrigin editOrigin) throws IOException {
        this.testPath();
        if (editOrigin != null) {
            StorageUtils.archive(this.file, this.backupFile, editOrigin);
        } else {
            this.backup();
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), ENCODING);
        BufferedWriter bufWriter = new BufferedWriter(writer);
        return bufWriter;
    }

    public BufferedOutputStream getOutputStream() throws IOException {
        return this.getOutputStream(true);
    }

    public BufferedOutputStream getOutputStream(boolean withBackup) throws IOException {
        this.testPath();
        if (withBackup) {
            this.backup();
        }
        FileOutputStream outputStream = new FileOutputStream(this.file);
        BufferedOutputStream bufOutputStream = new BufferedOutputStream(outputStream);
        return bufOutputStream;
    }

    public BufferedOutputStream archiveAndGetOutputStream(EditOrigin editOrigin) throws IOException {
        this.testPath();
        if (editOrigin != null) {
            StorageUtils.archive(this.file, this.backupFile, editOrigin);
        }
        FileOutputStream outputStream = new FileOutputStream(this.file);
        BufferedOutputStream bufOutputStream = new BufferedOutputStream(outputStream);
        return bufOutputStream;
    }

    public void archiveAndDelete(EditOrigin editOrigin) {
        try {
            if (editOrigin != null) {
                StorageUtils.archiveBeforeDelete(this.file, this.backupFile, editOrigin);
            }
            if (this.file.exists()) {
                FileUtils.forceDelete(this.file);
            }
        }
        catch (IOException ioe) {
            throw new BdfStorageException(this.file, (Throwable)ioe);
        }
    }

    private void testPath() {
        this.file.getParentFile().mkdirs();
        if (this.file.isDirectory()) {
            this.file.delete();
        }
    }

    private void backup() {
        if (this.file.exists() && this.backupFile != null && !this.file.isDirectory()) {
            try {
                FileUtils.copyFile(this.file, this.backupFile);
            }
            catch (IOException ioe) {
                throw new BdfStorageException(this.backupFile, (Throwable)ioe);
            }
        }
    }

    public static StorageFile build(File rootDir, File rootBackupDir, String path) {
        File file = new File(rootDir, path);
        File backupFile = null;
        if (rootBackupDir != null) {
            backupFile = new File(rootBackupDir, path);
        }
        return new StorageFile(path, file, backupFile);
    }
}

