/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.overview;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.ui.CommentUi;
import fr.exemole.bdfserver.api.ui.UiComponents;
import fr.exemole.bdfserver.tools.overview.OverviewBlock;
import fr.exemole.bdfserver.tools.ui.UiUtils;
import fr.exemole.bdfserver.tools.ui.components.CommentUiBuilder;
import net.mapeadores.util.attr.AttributeChangeBuilder;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.LineMessageException;

class CommentBlock
extends OverviewBlock {
    private final CommentUiBuilder builder;

    CommentBlock(int lineNumber, BdfServer bdfServer, CommentUi commentUi) {
        super(lineNumber, commentUi);
        this.builder = new CommentUiBuilder(bdfServer.getUiManager().getHtmlCleaner(), commentUi);
    }

    CommentBlock(int lineNumber, BdfServer bdfServer, String commentName) {
        super(lineNumber, commentName);
        this.builder = new CommentUiBuilder(bdfServer.getUiManager().getHtmlCleaner(), commentName);
    }

    @Override
    public boolean addText(String name, Lang lang, String text) {
        if (!this.isValidText(name)) {
            return false;
        }
        this.builder.putHtml(lang, text);
        return true;
    }

    private boolean isValidText(String labelName) {
        switch (labelName) {
            case "html": {
                return true;
            }
        }
        return false;
    }

    @Override
    public void put(int lineNumber, String key, String value) throws LineMessageException {
        switch (key) {
            case "location": {
                this.builder.setLocation(UiUtils.maskStringToInt(value));
                break;
            }
            default: {
                throw new LineMessageException(lineNumber, "severe.overview.fichotheque", "_ error.unknown.conf.key", key);
            }
        }
    }

    @Override
    public void put(int lineNumber, String key, String name, String value) throws LineMessageException {
        throw new LineMessageException(lineNumber, "severe.overview.fichotheque", "_ error.unknown.conf.key", key);
    }

    @Override
    public AttributeChangeBuilder getAttributeChangeBuilder() {
        return this.builder.getAttributeChangeBuilder();
    }

    @Override
    public void firstPass(EditSession editSession, UiComponents uiComponents) {
        editSession.getBdfServerEditor().putComponentUi(uiComponents, this.builder.toCommentUi());
    }

    @Override
    public void secondPass(EditSession editSession, UiComponents uiComponents) {
    }
}

