/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.interaction;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.users.BdfUser;
import java.text.ParseException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.selection.FicheCondition;
import net.fichotheque.selection.FicheQuery;
import net.fichotheque.selection.FieldContentCondition;
import net.fichotheque.selection.JunctionCondition;
import net.fichotheque.selection.MotcleCondition;
import net.fichotheque.selection.RangeCondition;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.UserLoginException;
import net.fichotheque.tools.selection.FicheQueryBuilder;
import net.fichotheque.tools.selection.JunctionConditionBuilder;
import net.fichotheque.tools.selection.MotcleQueryBuilder;
import net.fichotheque.tools.selection.PeriodConditionBuilder;
import net.fichotheque.tools.selection.UserConditionBuilder;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.SelectionUtils;
import net.fichotheque.utils.selection.RangeConditionBuilder;
import net.mapeadores.util.conditions.ConditionsConstants;
import net.mapeadores.util.conditions.ConditionsUtils;
import net.mapeadores.util.conditions.TextCondition;
import net.mapeadores.util.date.FuzzyDate;
import net.mapeadores.util.primitives.RangeUtils;
import net.mapeadores.util.primitives.Ranges;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class FicheQueryParser {
    public static final String ID_PARAMNAME = "id";
    public static final String CORPUS_ALL_PARAMNAME = "corpus_all";
    public static final String FICHE_LIST_PARAMNAME = "fiche_list";
    public static final String FICHE_LOGICALOPERATOR_PARAMNAME = "fiche_logicaloperator";
    public static final String FIELDCONTENT_PARAMNAME = "fieldcontent";
    public static final String FIELDCONTENT_OPERATOR_PARAMNAME = "fieldcontent_operator";
    public static final String FIELDCONTENT_SCOPE_PARAMNAME = "fieldcontent_scope";
    public static final String FIELDCONTENT_FIELDSELECTION_PARAMNAME = "fieldcontent_fieldselection";
    public static final String DISCARDFILTER_PARAMNAME = "discardfilter";
    public static final String USERS_ALL_PARAMNAME = "users_all";
    public static final String USERS_SELECTION_PARAMNAME = "users_selection";
    public static final String CORPUS_SELECTION_PARAMNAME = "corpus_selection";
    public static final String MOTCLE_ALL_PREFIX = "motcle_all_";
    public static final String MOTCLE_CONTENTOPERATOR_PREFIX = "motcle_contentoperator_";
    public static final String MOTCLE_INPUT_PREFIX = "motcle_input_";
    public static final String MOTCLE_SELECTION_PREFIX = "motcle_selection_";
    public static final String MOTCLE_SATELLITE_PREFIX = "motcle_satellite_";
    public static final String MOTCLE_LOGICALOPERATOR_PARAMNAME = "motcle_logicaloperator";
    public static final String PERIOD_START_PARAMNAME = "period_start";
    public static final String PERIOD_END_PARAMNAME = "period_end";
    public static final String PERIOD_SCOPE_PARAMNAME = "period_scope";
    public static final String PERIOD_FIELDLIST_PARAMNAME = "period_fieldlist";
    public static final String CREATION_PARAMVALUE = "creation";
    public static final String MODIFICATION_PARAMVALUE = "modification";
    public static final String FIELDLIST_PARAMVALUE = "fieldlist";
    private static final Set<FieldKey> EMPTY_FIELDKEYSET = Collections.emptySet();
    private final RequestMap requestMap;
    private final BdfServer bdfServer;
    private final BdfUser bdfUser;
    private final FicheQueryBuilder queryBuilder;

    private FicheQueryParser(RequestMap requestMap, BdfServer bdfServer, BdfUser bdfUser) {
        this.bdfServer = bdfServer;
        this.bdfUser = bdfUser;
        this.requestMap = requestMap;
        this.queryBuilder = new FicheQueryBuilder();
        this.parseId();
        this.parseCorpus();
        this.parseDiscardFilter();
        this.parseFieldContentCondition();
        this.parseUsers();
        this.parsePeriod();
        this.parseMotcles();
        this.parseFicheCondition();
    }

    public static FicheQuery parse(RequestMap requestMap, BdfServer bdfServer, BdfUser bdfUser) {
        FicheQueryParser parser = new FicheQueryParser(requestMap, bdfServer, bdfUser);
        return parser.queryBuilder.toFicheQuery();
    }

    private void parseId() {
        Ranges ranges;
        String rangeString = this.requestMap.getTrimedParameter(ID_PARAMNAME);
        if (!rangeString.isEmpty() && (ranges = RangeUtils.positiveRangeParse(rangeString)) != null) {
            this.queryBuilder.setIdRangeCondition(RangeConditionBuilder.init(ranges).toRangeCondition());
        }
    }

    private void parseCorpus() {
        String[] selectioncorpus;
        if (!this.requestMap.isTrue(CORPUS_ALL_PARAMNAME) && (selectioncorpus = this.requestMap.getParameterValues(CORPUS_SELECTION_PARAMNAME)) != null && selectioncorpus.length > 0) {
            for (String name : selectioncorpus) {
                try {
                    this.queryBuilder.addCorpus(SubsetKey.parse((short)1, name));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
    }

    private void parseFieldContentCondition() {
        String contentOperator = ConditionsConstants.checkLogicalOperator(this.requestMap.getParameter(FIELDCONTENT_OPERATOR_PARAMNAME), "and");
        TextCondition fieldCondition = ConditionsUtils.parseSimpleCondition(this.requestMap.getParameter(FIELDCONTENT_PARAMNAME), contentOperator);
        if (fieldCondition != null && !ConditionsUtils.isNeutral(fieldCondition)) {
            String fieldContentScope = "title";
            String scopeString = this.requestMap.getParameter(FIELDCONTENT_SCOPE_PARAMNAME);
            if (scopeString != null) {
                try {
                    fieldContentScope = FieldContentCondition.checkScope(scopeString);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            Set<FieldKey> fieldKeySet = null;
            if (fieldContentScope.equals("selection") && (fieldKeySet = FicheQueryParser.parseFieldKeySet(this.requestMap.getParameter(FIELDCONTENT_FIELDSELECTION_PARAMNAME))).isEmpty()) {
                fieldContentScope = "title";
            }
            this.queryBuilder.setFieldContentCondition(fieldCondition, fieldContentScope, fieldKeySet);
        }
    }

    private void parseDiscardFilter() {
        String discardFilter = "all";
        String discardParamValue = this.requestMap.getTrimedParameter(DISCARDFILTER_PARAMNAME);
        if (!discardParamValue.isEmpty()) {
            try {
                discardFilter = FicheQuery.checkDiscardFilter(discardParamValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.queryBuilder.setDiscardFilter(discardFilter);
    }

    private void parseUsers() {
        if (this.requestMap.isTrue(USERS_ALL_PARAMNAME)) {
            return;
        }
        String selectionParamValue = this.requestMap.getTrimedParameter(USERS_SELECTION_PARAMNAME);
        if (selectionParamValue.isEmpty()) {
            return;
        }
        if (selectionParamValue.equals("*")) {
            this.queryBuilder.setUserCondition(SelectionUtils.ANY_USERCONDITION);
        } else if (selectionParamValue.equals("!*")) {
            this.queryBuilder.setUserCondition(SelectionUtils.NONE_USERCONDITION);
        } else {
            String[] tokens;
            UserConditionBuilder userConditionBuilder = new UserConditionBuilder();
            SubsetKey defaultSphereKey = this.bdfUser.getRedacteur().getSubsetKey();
            for (String token : tokens = StringUtils.getTechnicalTokens(selectionParamValue, false)) {
                if (token.charAt(0) == '[') {
                    if (token.charAt(token.length() - 1) != ']') continue;
                    try {
                        SubsetKey sphereKey = SubsetKey.parse((short)3, token.substring(1, token.length() - 1));
                        userConditionBuilder.addSphere(sphereKey);
                    }
                    catch (ParseException sphereKey) {}
                    continue;
                }
                try {
                    Redacteur redacteur = this.bdfServer.getFichothequeQuestioner().getRedacteurByLogin(token, defaultSphereKey);
                    userConditionBuilder.addId(redacteur);
                }
                catch (UserLoginException userLoginException) {
                    // empty catch block
                }
            }
            if (!userConditionBuilder.isEmpty()) {
                this.queryBuilder.setUserCondition(userConditionBuilder.toUserCondition());
            }
        }
    }

    private void parsePeriod() {
        String[] values;
        String startDateString = this.requestMap.getTrimedParameter(PERIOD_START_PARAMNAME);
        if (startDateString.isEmpty()) {
            return;
        }
        PeriodConditionBuilder builder = new PeriodConditionBuilder();
        if (startDateString.equals("*")) {
            builder.setAnyStartDate();
        } else {
            try {
                FuzzyDate startDate = FuzzyDate.parse(startDateString);
                builder.setStartDate(startDate);
            }
            catch (ParseException pe) {
                return;
            }
        }
        String endDateString = this.requestMap.getTrimedParameter(PERIOD_END_PARAMNAME);
        if (!endDateString.isEmpty()) {
            if ((endDateString = endDateString.trim()).equals("*")) {
                builder.setAnyEndDate();
            } else {
                try {
                    FuzzyDate endDate = FuzzyDate.parse(endDateString);
                    builder.setEndDate(endDate);
                }
                catch (ParseException endDate) {
                    // empty catch block
                }
            }
        }
        if ((values = this.requestMap.getParameterValues(PERIOD_SCOPE_PARAMNAME)) != null) {
            for (String value : values) {
                if (value.equals(CREATION_PARAMVALUE)) {
                    builder.setOnCreationDate(true);
                    continue;
                }
                if (value.equals(MODIFICATION_PARAMVALUE)) {
                    builder.setOnModificationDate(true);
                    continue;
                }
                if (!value.equals(FIELDLIST_PARAMVALUE)) continue;
                builder.addFieldKeys(FicheQueryParser.parseFieldKeySet(this.requestMap.getParameter(PERIOD_FIELDLIST_PARAMNAME)));
            }
        }
        this.queryBuilder.setPeriodCondition(builder.toPeriodCondition());
    }

    private void parseMotcles() {
        this.queryBuilder.setMotcleLogicalOperator(this.getLogicalOperator(MOTCLE_LOGICALOPERATOR_PARAMNAME));
        TreeSet<Integer> suffixSet = new TreeSet<Integer>();
        for (String parameterName : this.requestMap.getParameterNameSet()) {
            int idx;
            if (!parameterName.startsWith(MOTCLE_INPUT_PREFIX) || (idx = parameterName.lastIndexOf(95)) == -1) continue;
            try {
                int number = Integer.parseInt(parameterName.substring(idx + 1));
                suffixSet.add(number);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        for (Integer itg : suffixSet) {
            MotcleCondition.Entry motcleConditionEntry = this.parseOptions(itg.toString());
            if (motcleConditionEntry == null) continue;
            this.queryBuilder.addMotcleConditionEntry(motcleConditionEntry);
        }
    }

    private MotcleCondition.Entry parseOptions(String suffix) {
        String[] selectionthesaurus;
        String chmtcl = this.requestMap.getTrimedParameter(MOTCLE_INPUT_PREFIX + suffix);
        if (chmtcl.isEmpty()) {
            return null;
        }
        TextCondition motcleCondition = ConditionsUtils.parseCondition(chmtcl, this.getLogicalOperator(MOTCLE_CONTENTOPERATOR_PREFIX + suffix));
        if (ConditionsUtils.isNeutral(motcleCondition)) {
            return null;
        }
        MotcleQueryBuilder motcleQueryBuilder = MotcleQueryBuilder.init().setContentCondition(motcleCondition, "idalpha_only");
        if (!this.requestMap.isTrue(MOTCLE_ALL_PREFIX + suffix) && (selectionthesaurus = this.requestMap.getParameterValues(MOTCLE_SELECTION_PREFIX + suffix)) != null && selectionthesaurus.length > 0) {
            String thesaurusIdList = StringUtils.implode(selectionthesaurus, ';');
            motcleQueryBuilder.addThesaurus(FichothequeUtils.toSubsetKeySet((short)2, thesaurusIdList));
        }
        boolean withMaster = this.requestMap.isTrue(MOTCLE_SATELLITE_PREFIX + suffix);
        return SelectionUtils.toMotcleConditionEntry(motcleQueryBuilder.toMotcleQuery(), null, withMaster);
    }

    private void parseFicheCondition() {
        String[] tokens;
        String ficheList = this.requestMap.getTrimedParameter(FICHE_LIST_PARAMNAME);
        if (ficheList.isEmpty()) {
            return;
        }
        this.queryBuilder.setFicheLogicalOperator(this.getLogicalOperator(FICHE_LOGICALOPERATOR_PARAMNAME));
        for (String token : tokens = StringUtils.getTokens(ficheList, ';', (short)2)) {
            try {
                FicheCondition.Entry entry = this.parseFicheEntry(token);
                this.queryBuilder.addFicheConditionQuery(entry);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    private String getLogicalOperator(String paramName) {
        String logicalOperator = this.requestMap.getTrimedParameter(paramName);
        logicalOperator = ConditionsConstants.checkLogicalOperator(logicalOperator, "and");
        return logicalOperator;
    }

    public static Set<FieldKey> parseFieldKeySet(String s) {
        if (s == null) {
            return EMPTY_FIELDKEYSET;
        }
        String[] tokens = StringUtils.getTechnicalTokens(s, true);
        int length = tokens.length;
        if (length == 0) {
            return EMPTY_FIELDKEYSET;
        }
        LinkedHashSet<FieldKey> fieldKeySet = new LinkedHashSet<FieldKey>();
        for (int i = 0; i < length; ++i) {
            try {
                FieldKey fieldKey = FieldKey.parse(tokens[i]);
                fieldKeySet.add(fieldKey);
                continue;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return fieldKeySet;
    }

    private FicheCondition.Entry parseFicheEntry(String entryString) throws ParseException {
        int idx = entryString.indexOf(47);
        if (idx < 1) {
            throw new ParseException("no /", 0);
        }
        SubsetKey corpusKey = SubsetKey.parse((short)1, entryString.substring(0, idx));
        String[] tokens = StringUtils.getTokens(entryString = entryString.substring(idx + 1), '|', (short)1);
        int length = tokens.length;
        if (length == 0) {
            throw new ParseException("no id range", 0);
        }
        RangeCondition idRangeCondition = this.parseRangeCondition(tokens[0]);
        if (idRangeCondition == null) {
            throw new ParseException("false id range = " + tokens[0], idx + 1);
        }
        FicheQuery ficheQuery = FicheQueryBuilder.init().addCorpus(corpusKey).setIdRangeCondition(idRangeCondition).toFicheQuery();
        JunctionCondition junctionCondition = null;
        if (length > 1) {
            RangeCondition weightRangeCondition;
            JunctionConditionBuilder builder = JunctionConditionBuilder.init();
            for (String modeToken : StringUtils.getTechnicalTokens(tokens[1], true)) {
                builder.addTieMode(modeToken);
            }
            if (length > 2 && (weightRangeCondition = this.parseRangeCondition(tokens[2])) != null) {
                builder.setWeightRangeCondition(weightRangeCondition);
            }
            if (!builder.isEmpty()) {
                junctionCondition = builder.toJunctionCondition();
            }
        }
        return SelectionUtils.toFicheConditionEntry(ficheQuery, junctionCondition, false);
    }

    private RangeCondition parseRangeCondition(String token) {
        Ranges ranges;
        int length = token.length();
        if (length == 0) {
            return null;
        }
        boolean exclude = false;
        if (token.charAt(0) == '!') {
            exclude = true;
            if (length == 1) {
                return null;
            }
            token = token.substring(1);
        }
        if ((ranges = RangeUtils.positiveRangeParse(token)) == null) {
            return null;
        }
        return RangeConditionBuilder.init(ranges).setExclude(exclude).toRangeCondition();
    }
}

