/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.instruction;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.util.Map;
import java.util.Set;
import net.fichotheque.Fichotheque;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public abstract class AbstractRequestHandler {
    protected final BdfServer bdfServer;
    protected final RequestMap requestMap;
    private Map<String, String> defaultMap = null;

    public AbstractRequestHandler(BdfServer bdfServer, RequestMap requestMap) {
        this.bdfServer = bdfServer;
        this.requestMap = requestMap;
    }

    public void setDefaultMap(Map<String, String> defaultMap) {
        this.defaultMap = defaultMap;
    }

    protected abstract void store(String var1, String var2);

    public BdfServer getBdfServer() {
        return this.bdfServer;
    }

    public Fichotheque getFichotheque() {
        return this.bdfServer.getFichotheque();
    }

    public RequestMap getRequestMap() {
        return this.requestMap;
    }

    public Set<String> getParameterNameSet() {
        return this.requestMap.getParameterNameSet();
    }

    public boolean hasParameter(String paramName) {
        return this.requestMap.getParameter(paramName) != null;
    }

    public boolean isTrue(String paramName) {
        String paramValue = this.requestMap.getTrimedParameter(paramName);
        if (paramValue == null) {
            return false;
        }
        this.store(paramName, paramValue);
        return StringUtils.isTrue(paramValue);
    }

    public String getParameter(String paramName, boolean mandatory) throws ErrorMessageException {
        if (mandatory) {
            return this.getMandatoryParameter(paramName);
        }
        return this.getTrimedParameter(paramName);
    }

    public String getMandatoryParameter(String paramName) throws ErrorMessageException {
        String paramValue = this.requestMap.getParameter(paramName);
        if (paramValue == null) {
            throw BdfErrors.emptyMandatoryParameter(paramName);
        }
        this.store(paramName, paramValue);
        return paramValue;
    }

    public String getTrimedParameter(String paramName) {
        return this.getTrimedParameter(paramName, "");
    }

    public String getTrimedParameter(String paramName, boolean allowsNull) {
        if (allowsNull) {
            String paramValue = this.requestMap.getParameter(paramName);
            if (paramValue == null) {
                return null;
            }
            if ((paramValue = paramValue.trim()).isEmpty() && this.defaultMap != null) {
                return this.defaultMap.get(paramName);
            }
            return paramValue;
        }
        return this.getTrimedParameter(paramName, "");
    }

    public String getTrimedParameter(String paramName, String defaultValue) {
        String paramValue = this.requestMap.getTrimedParameter(paramName);
        if (paramValue.isEmpty()) {
            String value;
            if (this.defaultMap != null && (value = this.defaultMap.get(paramName)) != null && !value.isEmpty()) {
                return value;
            }
            return defaultValue;
        }
        this.store(paramName, paramValue);
        return paramValue;
    }

    public String[] getTokens(String paramName) {
        String value;
        String[] tokens = this.requestMap.getParameterValues(paramName);
        if (tokens != null) {
            String compilation = StringUtils.implode(tokens, ';');
            this.store(paramName, compilation);
            return tokens;
        }
        if (this.defaultMap != null && (value = this.defaultMap.get(paramName)) != null && !value.isEmpty()) {
            return StringUtils.getTokens(value, ';', (short)2);
        }
        return StringUtils.EMPTY_STRINGARRAY;
    }
}

