/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.exportation.transformation;

import net.fichotheque.exportation.transformation.TemplateKey;
import net.fichotheque.exportation.transformation.TransformationKey;

public class TransformationAvailabilities {
    private TransformationAvailabilities() {
    }

    public static boolean isValidTemplateType(String templateType, TemplateKey templateKey) {
        TransformationKey transformationKey = templateKey.getTransformationKey();
        if (templateKey.isSimpleTemplate()) {
            switch (templateType) {
                case "xslt": {
                    return true;
                }
            }
            return false;
        }
        String extension = templateKey.getExtension();
        if (extension.equals("odt")) {
            switch (templateType) {
                case "xslt": {
                    return TransformationAvailabilities.acceptXsltOdt(transformationKey);
                }
                case "properties": {
                    return TransformationAvailabilities.acceptPropertiesOdt(transformationKey);
                }
            }
            return false;
        }
        return false;
    }

    public static boolean acceptXsltOdt(TransformationKey transformationKey) {
        if (transformationKey.isCorpusTransformationKey()) {
            return true;
        }
        switch (transformationKey.getKeyString()) {
            case "compilation": {
                return true;
            }
        }
        return false;
    }

    public static boolean acceptPropertiesOdt(TransformationKey transformationKey) {
        return transformationKey.isCorpusTransformationKey();
    }

    public static boolean hasDefaultFragment(TransformationKey transformationKey) {
        switch (transformationKey.getKeyString()) {
            case "section": 
            case "format": {
                return true;
            }
        }
        return false;
    }

    public static boolean hasDefaultExtractionDef(TransformationKey transformationKey) {
        if (transformationKey.isCorpusTransformationKey()) {
            return true;
        }
        switch (transformationKey.getKeyString()) {
            case "compilation": 
            case "statthesaurus": {
                return true;
            }
        }
        return false;
    }

    public static boolean useCorpusListAttribute(TransformationKey transformationKey) {
        switch (transformationKey.getKeyString()) {
            case "compilation": {
                return true;
            }
        }
        return false;
    }
}

