/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.tools.balayage.engine;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.configuration.PathConfiguration;
import fr.exemole.bdfserver.tools.BdfURI;
import fr.exemole.bdfserver.tools.balayage.engine.BalayageEngine;
import fr.exemole.bdfserver.tools.balayage.engine.BalayageLog;
import fr.exemole.bdfserver.tools.balayage.engine.BalayageParameters;
import fr.exemole.bdfserver.tools.balayage.engine.SiteMapBuilder;
import java.io.File;
import java.util.Map;
import net.fichotheque.exportation.balayage.BalayageDef;
import net.fichotheque.exportation.balayage.BalayageDescription;
import net.fichotheque.exportation.balayage.BalayageMode;
import net.fichotheque.exportation.balayage.SiteMapOption;
import net.fichotheque.namespaces.BalayageSpace;
import net.fichotheque.tools.exportation.balayage.SiteMapOptionBuilder;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.text.RelativePath;

public class BalayageInitializer {
    private final BdfServer bdfServer;
    private final BalayageDescription balayageDescription;
    private final BalayageDef balayageDef;
    private final PathConfiguration pathConfiguration;
    private File balayageRootDirectory;
    private String errorMessageKey;
    private Object errorMessageValue;
    private BalayageMode balayageMode;

    public BalayageInitializer(BdfServer bdfServer, BalayageDescription balayageDescription, PathConfiguration pathConfiguration) {
        this.bdfServer = bdfServer;
        this.balayageDescription = balayageDescription;
        this.balayageDef = balayageDescription.getBalayageDef();
        this.pathConfiguration = pathConfiguration;
        this.init();
    }

    private void init() {
        String targetName = this.balayageDef.getTargetName();
        if (targetName == null) {
            this.errorMessageKey = "_ error.empty.balayage.root";
            return;
        }
        File targetDirectory = this.pathConfiguration.getTargetDirectory(targetName);
        if (targetDirectory == null) {
            targetDirectory = this.bdfServer.getOutputStorage().getFile(RelativePath.build("balayages/" + this.balayageDef.getName()));
            targetDirectory.mkdirs();
        }
        if (!targetDirectory.exists()) {
            String[] err;
            this.errorMessageKey = "_ error.unknown.balayage.root";
            this.errorMessageValue = err = new String[]{targetName, targetDirectory.getAbsolutePath()};
            return;
        }
        if (!targetDirectory.isDirectory()) {
            String[] err;
            this.errorMessageKey = "_ error.wrong.balayage.root_notdirectory";
            this.errorMessageValue = err = new String[]{targetName, targetDirectory.getAbsolutePath()};
            return;
        }
        RelativePath targetPath = this.balayageDef.getTargetPath();
        if (!targetPath.isEmpty()) {
            this.balayageRootDirectory = new File(targetDirectory, targetPath.getPath());
            if (!this.balayageRootDirectory.exists()) {
                this.balayageRootDirectory.mkdirs();
            } else if (!this.balayageRootDirectory.isDirectory()) {
                this.errorMessageKey = "_ error.wrong.balayage.path_notdirectory";
                this.errorMessageValue = this.balayageRootDirectory.getAbsolutePath();
                return;
            }
        } else {
            this.balayageRootDirectory = targetDirectory;
        }
        if (this.balayageDef.getBalayageUnitList().isEmpty()) {
            this.errorMessageKey = "_ error.empty.balayage.unit";
        }
    }

    public boolean hasError() {
        return this.errorMessageKey != null;
    }

    public String getErrorMessageKey() {
        return this.errorMessageKey;
    }

    public Object getErrorMessageValue() {
        return this.errorMessageValue;
    }

    public void setBalayageMode(BalayageMode balayageMode) {
        this.balayageMode = balayageMode;
    }

    public BalayageEngine getBalayageEngine(BalayageLog balayageLog) {
        if (this.hasError()) {
            return null;
        }
        BalayageParameters balayageParameters = BalayageParameters.init(this.balayageDescription, this.bdfServer, this.pathConfiguration).setBalayageMode(this.balayageMode).setBalayageLog(balayageLog).setBalayageRootDirectory(this.balayageRootDirectory).setCustomURIResolver(BdfURI.getURIResolver(this.bdfServer, this.pathConfiguration, true));
        SiteMapOption siteMapOption = this.initSiteMapOption();
        if (siteMapOption != null) {
            SiteMapBuilder siteMapBuilder = new SiteMapBuilder(siteMapOption);
            balayageParameters.setFileGenerationListener(siteMapBuilder);
        }
        BalayageEngine balayageEngine = new BalayageEngine(balayageParameters);
        return balayageEngine;
    }

    private SiteMapOption initSiteMapOption() {
        Attribute attribute = this.balayageDef.getAttributes().getAttribute(BalayageSpace.SITEMAP_KEY);
        if (attribute == null) {
            return null;
        }
        Map<String, String> map = attribute.toSubParamMap();
        return SiteMapOptionBuilder.init().setPath(map.get("path")).setBaseUrl(map.get("base-url")).setFileName(map.get("file-name")).toSiteMapOption();
    }
}

