/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.implementations;

import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.api.storage.StorageContent;
import fr.exemole.bdfserver.api.storage.TableExportStorage;
import fr.exemole.bdfserver.conf.BdfServerDirs;
import fr.exemole.bdfserver.conf.ConfDirs;
import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.storage.directory.StorageDirectoryUtils;
import fr.exemole.bdfserver.tools.storage.StorageFile;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import fr.exemole.bdfserver.tools.storage.TableExportStorageUnitBuilder;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeMap;
import net.fichotheque.EditOrigin;
import net.fichotheque.exportation.table.TableExportDef;
import net.fichotheque.tools.exportation.table.TableExportDefBuilder;
import net.fichotheque.tools.exportation.table.dom.TableExportDefDOMReader;
import net.fichotheque.xml.defs.TableExportDefXMLPart;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Document;

public class TableExportStorageImpl
implements TableExportStorage {
    private final StorageDirectory tableExportDirectory;

    public TableExportStorageImpl(BdfServerDirs dirs) {
        this.tableExportDirectory = StorageDirectoryUtils.toStorageDirectory((ConfDirs)dirs, "tableexportdata");
    }

    @Override
    public TableExportStorage.Unit[] checkStorage() {
        TreeMap<String, TableExportStorage.Unit> map = new TreeMap<String, TableExportStorage.Unit>();
        this.scanTableExportDirectories(map);
        return map.values().toArray(new TableExportStorage.Unit[map.size()]);
    }

    @Override
    public TableExportStorage.Unit getTableExportStorageUnit(String tableExportName) {
        if (!TableExportStorageImpl.testName(tableExportName)) {
            return null;
        }
        File varDir = this.tableExportDirectory.getDataFile(tableExportName);
        if (varDir.exists() && varDir.isDirectory()) {
            return this.buildUnit(tableExportName);
        }
        return null;
    }

    @Override
    public boolean saveTableExportDef(TableExportDef tableExportDef, EditOrigin editOrigin) {
        String tableExportName = tableExportDef.getName();
        if (!TableExportStorageImpl.testName(tableExportName)) {
            return false;
        }
        StorageFile storageFile = this.getStorageFile(tableExportName, "_def.xml");
        try (BufferedWriter writer = storageFile.archiveAndGetWriter(editOrigin);){
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(writer);
            xmlWriter.appendXMLDeclaration();
            TableExportDefXMLPart.init(xmlWriter).addTableExportDef(tableExportDef);
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
        return true;
    }

    @Override
    public boolean removeTableExport(String tableExportName, EditOrigin editOrigin) {
        if (!TableExportStorageImpl.testName(tableExportName)) {
            return false;
        }
        StorageFile tableExportDir = this.tableExportDirectory.getStorageFile(tableExportName);
        if (!tableExportDir.exists() || !tableExportDir.isDirectory()) {
            return false;
        }
        StorageDirectoryUtils.archiveAndDeleteDirectory(tableExportDir, editOrigin);
        return true;
    }

    @Override
    public boolean copyTableExport(String tableExportName, String newTableExportName, EditOrigin editOrigin) {
        if (!TableExportStorageImpl.testName(tableExportName)) {
            return false;
        }
        if (!TableExportStorageImpl.testName(newTableExportName)) {
            throw new IllegalArgumentException(newTableExportName + " is not a technical name");
        }
        File sourceDir = this.tableExportDirectory.getDataDir(tableExportName);
        StorageFile destinationDir = this.tableExportDirectory.getStorageFile(newTableExportName);
        if (destinationDir.exists()) {
            return false;
        }
        StorageDirectoryUtils.copyAndArchiveDirectory(sourceDir, destinationDir, editOrigin);
        return true;
    }

    @Override
    public StorageContent getStorageContent(String tableExportName, String contentPath) {
        if (!TableExportStorageImpl.testName(tableExportName)) {
            return null;
        }
        if ((contentPath = TableExportStorageImpl.checkPath(contentPath)) == null) {
            return null;
        }
        StorageFile storageFile = this.getStorageFile(tableExportName, contentPath);
        if (!storageFile.exists()) {
            return null;
        }
        return StorageUtils.toStorageContent(contentPath, storageFile.getFile());
    }

    @Override
    public void saveStorageContent(String tableExportName, String contentPath, InputStream inputStream, EditOrigin editOrigin) throws IOException {
        if (!TableExportStorageImpl.testName(tableExportName)) {
            throw new IllegalArgumentException(tableExportName + " is not a technical name");
        }
        if ((contentPath = TableExportStorageImpl.checkPath(contentPath)) == null) {
            throw new IllegalArgumentException(contentPath + " is not a relative path");
        }
        StorageFile storageFile = this.getStorageFile(tableExportName, contentPath);
        try (BufferedOutputStream os = storageFile.archiveAndGetOutputStream(editOrigin);){
            IOUtils.copy(inputStream, (OutputStream)os);
        }
    }

    @Override
    public boolean removeStorageContent(String tableExportName, String contentPath, EditOrigin editOrigin) {
        if (!TableExportStorageImpl.testName(tableExportName)) {
            return false;
        }
        if ((contentPath = TableExportStorageImpl.checkPath(contentPath)) == null) {
            return false;
        }
        StorageFile storageFile = this.getStorageFile(tableExportName, contentPath);
        if (storageFile.exists()) {
            storageFile.archiveAndDelete(editOrigin);
            return true;
        }
        return false;
    }

    private void scanTableExportDirectories(Map<String, TableExportStorage.Unit> map) {
        File dataDir = this.tableExportDirectory.getDataDir();
        if (!dataDir.exists()) {
            return;
        }
        if (!dataDir.isDirectory()) {
            return;
        }
        for (File file : dataDir.listFiles()) {
            String name;
            if (!file.isDirectory() || !TableExportStorageImpl.testName(name = file.getName()) || map.containsKey(name)) continue;
            TableExportStorage.Unit unit = this.buildUnit(name);
            map.put(name, unit);
        }
    }

    private TableExportStorage.Unit buildUnit(String name) {
        StorageFile dir = this.tableExportDirectory.getStorageFile(name);
        TableExportStorageUnitBuilder builder = new TableExportStorageUnitBuilder();
        TableExportDefBuilder tableExportDefBuilder = new TableExportDefBuilder(name);
        for (StorageFile storageFile : dir.listFiles()) {
            if (storageFile.isDirectory()) continue;
            String fileName = storageFile.getName();
            if (fileName.endsWith(".txt") && fileName.length() > 4) {
                if (!TableExportStorageImpl.testName(fileName.substring(0, fileName.length() - 4))) continue;
                builder.addStorageContent(StorageUtils.toStorageContent(fileName, storageFile.getFile()));
                continue;
            }
            if (!fileName.equals("_def.xml")) continue;
            Document doc = storageFile.readDocument();
            TableExportDefDOMReader.init(tableExportDefBuilder, LogUtils.NULL_MESSAGEHANDLER).read(doc.getDocumentElement());
        }
        builder.setTableExportDef(tableExportDefBuilder.toTableExportDef());
        return builder.toTableExportStorageUnit();
    }

    private StorageFile getStorageFile(String tableExportName, String fileName) {
        String path = tableExportName + File.separator + fileName;
        return this.tableExportDirectory.getStorageFile(path);
    }

    private static boolean testName(String s) {
        return StringUtils.isTechnicalName(s, true);
    }

    private static String checkPath(String path) {
        if ((path = StringUtils.normalizeRelativePath(path)) == null) {
            return null;
        }
        switch (path) {
            case "_def.xml": {
                return null;
            }
        }
        return path;
    }
}

