/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.implementations;

import fr.exemole.bdfserver.api.roles.RoleDef;
import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.api.storage.RoleStorage;
import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.tools.roles.RoleDefBuilder;
import fr.exemole.bdfserver.tools.roles.dom.RoleDefDOMReader;
import fr.exemole.bdfserver.tools.storage.StorageFile;
import fr.exemole.bdfserver.xml.roles.RoleDefXMLPart;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.logging.MultiMessageHandler;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Document;

public class RoleStorageImpl
implements RoleStorage {
    private final StorageDirectory bdfdataDirectory;
    private final String rootPath = "conf" + File.separator + "roles";

    public RoleStorageImpl(StorageDirectory bdfdataDirectory) {
        this.bdfdataDirectory = bdfdataDirectory;
    }

    public List<RoleDef> check(MultiMessageHandler messageHandler) {
        ArrayList<RoleDef> result = new ArrayList<RoleDef>();
        File roleDirectory = this.bdfdataDirectory.getDataDir(this.rootPath);
        if (!roleDirectory.exists()) {
            return result;
        }
        for (File f : roleDirectory.listFiles()) {
            String fileName = f.getName();
            if (!fileName.endsWith(".xml")) continue;
            String roleName = fileName.substring(0, fileName.length() - 4);
            try {
                RoleDef.checkRoleName(roleName);
                RoleDefBuilder roleDefBuilder = RoleDefBuilder.init(roleName);
                StorageFile storageFile = this.bdfdataDirectory.getStorageFile(this.rootPath + File.separator + fileName);
                messageHandler.setCurrentSource(storageFile.toURI());
                Document doc = storageFile.readDocument();
                RoleDefDOMReader.init(roleDefBuilder, messageHandler).read(doc.getDocumentElement());
                result.add(roleDefBuilder.toRoleDef());
            }
            catch (ParseException pe) {
                messageHandler.setCurrentSource(f.getPath());
                messageHandler.addMessage("severe.directorystorage.filename", "_ error.wrong.filename", roleName);
            }
        }
        return result;
    }

    @Override
    public void saveRoleDef(RoleDef roleDef) {
        StorageFile storageFile = this.getRoleFile(roleDef.getName());
        try (BufferedWriter buf = storageFile.getWriter();){
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf);
            xmlWriter.appendXMLDeclaration();
            RoleDefXMLPart xmlPart = new RoleDefXMLPart(xmlWriter);
            xmlPart.addRoleDef(roleDef);
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    @Override
    public void removeRoleDef(String roleName) {
        StorageFile storageFile = this.getRoleFile(roleName);
        storageFile.delete();
    }

    private StorageFile getRoleFile(String roleName) {
        return this.bdfdataDirectory.getStorageFile(this.rootPath + File.separator + roleName + ".xml");
    }
}

