/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.implementations;

import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.api.storage.RedacteurListStorage;
import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.tools.roles.dom.RedacteurListDOMReader;
import fr.exemole.bdfserver.tools.storage.StorageFile;
import fr.exemole.bdfserver.xml.roles.RedacteurListXMLPart;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.Fichotheque;
import net.fichotheque.sphere.Redacteur;
import net.mapeadores.util.logging.MultiMessageHandler;
import net.mapeadores.util.xml.AppendableXMLWriter;
import net.mapeadores.util.xml.XMLUtils;
import org.w3c.dom.Document;

public class RedacteurListStorageImpl
implements RedacteurListStorage {
    private final StorageDirectory bdfdataDirectory;
    private final String rootPath = "conf" + File.separator + "redacteurlists";

    public RedacteurListStorageImpl(StorageDirectory bdfdataDirectory) {
        this.bdfdataDirectory = bdfdataDirectory;
    }

    @Override
    public void saveRedacteurList(String name, List<Redacteur> redacteurList) {
        StorageFile storageFile = this.getRedacteurListStorageFile(name);
        try (BufferedWriter buf = storageFile.getWriter();){
            AppendableXMLWriter xmlWriter = XMLUtils.toXMLWriter(buf);
            xmlWriter.appendXMLDeclaration();
            RedacteurListXMLPart xmlPart = new RedacteurListXMLPart(xmlWriter);
            xmlPart.addRedacteurList(redacteurList);
        }
        catch (IOException ioe) {
            throw new BdfStorageException(ioe);
        }
    }

    @Override
    public void removeRedacteurList(String name) {
        StorageFile storageFile = this.getRedacteurListStorageFile(name);
        if (storageFile.exists()) {
            storageFile.delete();
        }
    }

    public Map<String, List<Redacteur>> checkRedacteurListMap(MultiMessageHandler messageHandler, Fichotheque fichotheque) {
        HashMap<String, List<Redacteur>> result = new HashMap<String, List<Redacteur>>();
        File redacteurlistsDirectory = this.bdfdataDirectory.getDataDir(this.rootPath);
        if (!redacteurlistsDirectory.exists()) {
            return result;
        }
        RedacteurListDOMReader redacteurListDOMReader = new RedacteurListDOMReader(messageHandler, fichotheque);
        for (File f : redacteurlistsDirectory.listFiles()) {
            String fileName;
            if (f.isDirectory() || !(fileName = f.getName()).endsWith(".xml")) continue;
            String name = fileName.substring(0, fileName.length() - 4);
            StorageFile storageFile = this.bdfdataDirectory.getStorageFile(this.rootPath + File.separator + fileName);
            messageHandler.setCurrentSource(storageFile.toURI());
            Document doc = storageFile.readDocument();
            List<Redacteur> redacteurList = redacteurListDOMReader.readRedacteurList(doc.getDocumentElement());
            result.put(name, redacteurList);
        }
        return result;
    }

    private StorageFile getRedacteurListStorageFile(String name) {
        return this.bdfdataDirectory.getStorageFile(this.rootPath + File.separator + name + ".xml");
    }
}

