/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.storage.directory.implementations;

import fr.exemole.bdfserver.storage.directory.StorageDirectory;
import fr.exemole.bdfserver.storage.directory.bdfdata.BdfdataStorageFileCatalog;
import fr.exemole.bdfserver.storage.directory.bdfdata.Remove;
import fr.exemole.bdfserver.storage.directory.bdfdata.Save;
import fr.exemole.bdfserver.tools.storage.StorageFile;
import net.fichotheque.EditOrigin;
import net.fichotheque.impl.JunctionDataSource;
import net.fichotheque.junction.Junction;
import net.fichotheque.junction.JunctionKey;
import net.fichotheque.junction.JunctionRevision;
import net.fichotheque.tools.dom.revisions.JunctionRevisionDOMReader;
import org.w3c.dom.Document;

public class JunctionDataSourceImpl
implements JunctionDataSource {
    private final StorageDirectory bdfdataDirectory;

    public JunctionDataSourceImpl(StorageDirectory bdfdataDirectory) {
        this.bdfdataDirectory = bdfdataDirectory;
    }

    @Override
    public void saveJunction(Junction junction, EditOrigin editOrigin) {
        if (editOrigin == null) {
            throw new IllegalArgumentException("editOrigin is null");
        }
        Save.saveJunction(this.bdfdataDirectory, junction, editOrigin);
    }

    @Override
    public void removeJunction(JunctionKey junctionKey, EditOrigin editOrigin) {
        if (editOrigin == null) {
            throw new IllegalArgumentException("editOrigin is null");
        }
        Remove.removeJunction(this.bdfdataDirectory, junctionKey, editOrigin);
    }

    @Override
    public JunctionRevision getJunctionRevision(JunctionKey junctionKey, String revisionName) {
        StorageFile storageFile = BdfdataStorageFileCatalog.junction(this.bdfdataDirectory, junctionKey);
        Document document = storageFile.readDocument(revisionName);
        if (document == null) {
            return null;
        }
        JunctionRevisionDOMReader junctionRevisionDOMReader = new JunctionRevisionDOMReader();
        return junctionRevisionDOMReader.readJunctionRevision(document.getDocumentElement());
    }
}

