/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.servlets;

import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.multi.api.central.CentralUser;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import net.fichotheque.sphere.LoginKey;

public class BDFSession {
    private final Map<String, FichothequeInfo> fichothequeInfoMap = new LinkedHashMap<String, FichothequeInfo>();
    private final Map<LoginKey, LoginInfo> loginKeyMap = new LinkedHashMap<LoginKey, LoginInfo>();
    private final Set<LoginKey> unmodifiableLoginKeySet = Collections.unmodifiableSet(this.loginKeyMap.keySet());
    private final HttpSession session;
    private boolean multiAdmin = false;
    private CentralUser centralUser = null;

    public BDFSession(HttpSession session) {
        this.session = session;
    }

    public HttpSession getHttpSession() {
        return this.session;
    }

    public boolean isEmpty() {
        return this.centralUser == null && !this.multiAdmin && this.fichothequeInfoMap.isEmpty();
    }

    public boolean isMultiAdmin() {
        return this.multiAdmin;
    }

    public synchronized void setMultiAdmin(boolean multiAdmin) {
        this.multiAdmin = multiAdmin;
    }

    public boolean hasCentralUser() {
        return this.centralUser != null;
    }

    public CentralUser getCentralUser() {
        return this.centralUser;
    }

    public Set<LoginKey> getLoginKeySet() {
        return this.unmodifiableLoginKeySet;
    }

    public synchronized BdfUser getBdfUser(String fichothequeName) {
        FichothequeInfo fichothequeInfo = this.fichothequeInfoMap.get(fichothequeName);
        if (fichothequeInfo != null) {
            return fichothequeInfo.getBdfUser();
        }
        return null;
    }

    public synchronized void centralLogin(CentralUser centralUser) {
        if (this.centralUser != null) {
            return;
        }
        this.centralUser = centralUser;
        LoginKey loginKey = centralUser.getLoginKey();
        LoginInfo loginInfo = this.loginKeyMap.get(loginKey);
        if (loginInfo == null) {
            loginInfo = new LoginInfo();
            this.loginKeyMap.put(loginKey, loginInfo);
        }
        loginInfo.setCentralUser(true);
    }

    public synchronized void login(String fichothequeName, BdfUser bdfUser) {
        LoginKey loginKey = bdfUser.getLoginKey();
        LoginInfo loginInfo = this.loginKeyMap.get(loginKey);
        if (loginInfo == null) {
            loginInfo = new LoginInfo();
            this.loginKeyMap.put(loginKey, loginInfo);
        }
        loginInfo.addFichotheque(fichothequeName);
        this.fichothequeInfoMap.put(fichothequeName, new FichothequeInfo(loginKey, bdfUser));
    }

    public synchronized LoginKey logout(String fichothequeName) {
        FichothequeInfo fichothequeInfo = this.fichothequeInfoMap.remove(fichothequeName);
        LoginKey loginKey = null;
        if (fichothequeInfo != null) {
            loginKey = fichothequeInfo.getLoginKey();
            LoginInfo loginInfo = this.loginKeyMap.get(loginKey);
            loginInfo.removeFichotheque(fichothequeName);
            if (loginInfo.isEmpty()) {
                this.loginKeyMap.remove(loginKey);
            }
        }
        return loginKey;
    }

    public synchronized void logoutAll(LoginKey loginKey) {
        LoginInfo loginInfo = this.loginKeyMap.get(loginKey);
        if (loginInfo == null) {
            return;
        }
        for (String fichothequeName : loginInfo.fichothequeNameSet) {
            this.fichothequeInfoMap.remove(fichothequeName);
        }
        if (this.centralUser != null && this.centralUser.getLoginKey().equals(loginKey)) {
            this.centralUser = null;
        }
        loginInfo.clear();
        this.loginKeyMap.remove(loginKey);
    }

    public boolean containsBdfUser(String fichothequeName, BdfUser bdfUser) {
        FichothequeInfo fichothequeInfo = this.fichothequeInfoMap.get(fichothequeName);
        if (fichothequeInfo != null) {
            return fichothequeInfo.getBdfUser().equals(bdfUser);
        }
        return false;
    }

    private static class FichothequeInfo {
        private final LoginKey loginKey;
        private final BdfUser bdfUser;

        private FichothequeInfo(LoginKey loginKey, BdfUser bdfUser) {
            this.loginKey = loginKey;
            this.bdfUser = bdfUser;
        }

        private LoginKey getLoginKey() {
            return this.loginKey;
        }

        private BdfUser getBdfUser() {
            return this.bdfUser;
        }
    }

    private static class LoginInfo {
        private Set<String> fichothequeNameSet = new HashSet<String>();
        private boolean centralUser;

        private LoginInfo() {
        }

        private void setCentralUser(boolean centralUser) {
            this.centralUser = centralUser;
        }

        private void addFichotheque(String fichothequeName) {
            this.fichothequeNameSet.add(fichothequeName);
        }

        private void removeFichotheque(String fichothequeName) {
            this.fichothequeNameSet.remove(fichothequeName);
        }

        private void clear() {
            this.centralUser = false;
            this.fichothequeNameSet.clear();
        }

        private boolean isEmpty() {
            return !this.centralUser && this.fichothequeNameSet.isEmpty();
        }
    }
}

