/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.servlets;

import fr.exemole.bdfserver.api.BdfExtensionInitializer;
import fr.exemole.bdfserver.api.storage.BdfStorageException;
import fr.exemole.bdfserver.conf.BdfServerDirs;
import fr.exemole.bdfserver.conf.WebappDirs;
import fr.exemole.bdfserver.storage.directory.StorageFactory;
import fr.exemole.bdfserver.tools.storage.DirectoryEditableResourceStorage;
import fr.exemole.bdfserver.tools.storage.DistResourceStorage;
import fr.exemole.bdfserver.tools.storage.Storages;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.mapeadores.util.buildinfo.BuildInfo;
import net.mapeadores.util.buildinfo.BuildInfoParser;
import net.mapeadores.util.exceptions.ImplementationException;
import net.mapeadores.util.exceptions.InitException;
import net.mapeadores.util.exceptions.InternalResourceException;
import net.mapeadores.util.io.DirectoryResourceStorage;
import net.mapeadores.util.io.FileUtils;
import net.mapeadores.util.io.ResourceStorage;
import net.mapeadores.util.io.ResourceStorages;
import net.mapeadores.util.io.ResourceUtils;
import net.mapeadores.util.logging.SourceLogsBuilder;

public final class BDFInit {
    private BDFInit() {
    }

    public static BuildInfo buildInfo() {
        if (BDFInit.class.getResource("VERSION") != null) {
            BuildInfo buildInfo;
            block9: {
                InputStream is = BDFInit.class.getResourceAsStream("VERSION");
                try {
                    BuildInfo buildInfo2;
                    buildInfo = buildInfo2 = BuildInfoParser.parse(is);
                    if (is == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        throw new InternalResourceException(ioe);
                    }
                }
                is.close();
            }
            return buildInfo;
        }
        return null;
    }

    public static Storages storages(BdfServerDirs dirs, ResourceStorages webappsResourceStorages) {
        BDFInit.checkBalayage(dirs);
        SourceLogsBuilder logsBuilder = new SourceLogsBuilder();
        Storages storages = StorageFactory.newInstance(dirs, logsBuilder);
        storages.setInitLogs(logsBuilder.toSourceLogs()).setResourceStorages(BDFInit.initBdfServerResourceStorages(dirs, webappsResourceStorages));
        return storages;
    }

    public static List<BdfExtensionInitializer> extensionInitializerList(WebappDirs webappDirs) {
        List<BdfExtensionInitializer> bdfExtensionInitializerList;
        File dir = webappDirs.getDir("lib.extensions");
        if (dir == null || !dir.exists()) {
            return Collections.emptyList();
        }
        try {
            bdfExtensionInitializerList = BDFInit.extensionInitializerList(dir);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new InitException(e);
        }
        return bdfExtensionInitializerList;
    }

    private static List<BdfExtensionInitializer> extensionInitializerList(File dir) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        HashMap<String, String> existingRegistrationNameMap = new HashMap<String, String>();
        String intializerClassName = BdfExtensionInitializer.class.getName();
        ArrayList<URL> urlList = new ArrayList<URL>();
        ArrayList<File> fileList = new ArrayList<File>();
        for (File file : dir.listFiles()) {
            if (file.isDirectory() || !file.getName().endsWith(".jar")) continue;
            urlList.add(file.toURI().toURL());
            fileList.add(file);
        }
        if (urlList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BdfExtensionInitializer> bdfExtensionInitializerList = new ArrayList<BdfExtensionInitializer>();
        URLClassLoader loader = new URLClassLoader(urlList.toArray(new URL[urlList.size()]), BDFInit.class.getClassLoader());
        for (File file : fileList) {
            JarFile jar = new JarFile(file.getAbsolutePath());
            Enumeration<JarEntry> enumeration = jar.entries();
            while (enumeration.hasMoreElements()) {
                String tmp = ((Object)enumeration.nextElement()).toString();
                if (tmp.length() <= 6 || tmp.substring(tmp.length() - 6).compareTo(".class") != 0) continue;
                tmp = tmp.substring(0, tmp.length() - 6);
                tmp = tmp.replaceAll("/", ".");
                Class<?> tmpClass = Class.forName(tmp, true, loader);
                for (Class<?> interfaceClass : tmpClass.getInterfaces()) {
                    if (!interfaceClass.getName().equals(intializerClassName)) continue;
                    try {
                        BdfExtensionInitializer initializer = (BdfExtensionInitializer)tmpClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        String registrationName = initializer.getRegistrationName();
                        String current = (String)existingRegistrationNameMap.get(registrationName);
                        if (current != null) {
                            throw new InitException("same registration name: " + registrationName + " (" + current + " / " + initializer.getClass().getName() + ")");
                        }
                        existingRegistrationNameMap.put(registrationName, initializer.getClass().getName());
                        bdfExtensionInitializerList.add(initializer);
                    }
                    catch (ReflectiveOperationException roe) {
                        throw new ImplementationException("Class " + tmpClass.getCanonicalName() + " has no public constructor without parameters");
                    }
                }
            }
        }
        return bdfExtensionInitializerList;
    }

    public static ResourceStorages initWebappResourceStorages(WebappDirs webappDirs, List<BdfExtensionInitializer> bdfExtensionInitializerList) {
        File resourceEtcDir = webappDirs.getDir("etc.resources");
        ResourceStorage[] array = new ResourceStorage[]{new DirectoryResourceStorage("etc", resourceEtcDir), DistResourceStorage.newInstance(bdfExtensionInitializerList)};
        return ResourceUtils.toResourceStorages(array);
    }

    private static ResourceStorages initBdfServerResourceStorages(BdfServerDirs dirs, ResourceStorages webappsResourceStorages) {
        String subdirName = "rscdata";
        File resourceVarDir = dirs.getSubPath("var.data", subdirName);
        File resourceBackupDir = dirs.getSubPath("var.backup", subdirName);
        BDFInit.testOldVersion(resourceVarDir, resourceBackupDir);
        ArrayList<ResourceStorage> list = new ArrayList<ResourceStorage>();
        list.add(new DirectoryEditableResourceStorage("var", resourceVarDir, resourceBackupDir));
        list.addAll(webappsResourceStorages);
        return ResourceUtils.toResourceStorages(list.toArray(new ResourceStorage[list.size()]));
    }

    private static void testOldVersion(File varRscDirectory, File backupRscDirectory) {
        File imagesDir;
        if (varRscDirectory.exists()) {
            File[] fileArray = varRscDirectory.listFiles();
            int length = fileArray.length;
            for (int i = 0; i < length; ++i) {
                String name;
                File f = fileArray[i];
                if (!f.isDirectory() || !(name = f.getName()).startsWith("_") || name.length() <= 1) continue;
                f.renameTo(new File(varRscDirectory, name.substring(1)));
            }
            File rscDir = new File(varRscDirectory, "rsc");
            imagesDir = new File(varRscDirectory, "images");
            if (rscDir.exists()) {
                rscDir.renameTo(imagesDir);
            }
            for (int i = 0; i < length; ++i) {
                String name;
                File f = fileArray[i];
                if (f.isDirectory() || !(name = f.getName()).endsWith(".png") && !name.endsWith(".jpg")) continue;
                if (!imagesDir.exists()) {
                    imagesDir.mkdir();
                }
                f.renameTo(new File(imagesDir, name));
            }
        }
        if (backupRscDirectory.exists()) {
            for (File f : backupRscDirectory.listFiles()) {
                String name;
                if (!f.isDirectory() || !(name = f.getName()).startsWith("_") || name.length() <= 1) continue;
                f.renameTo(new File(backupRscDirectory, name.substring(1)));
            }
            File rscDir = new File(backupRscDirectory, "rsc");
            imagesDir = new File(backupRscDirectory, "images");
            if (rscDir.exists()) {
                rscDir.renameTo(imagesDir);
            }
        }
    }

    private static void checkBalayage(BdfServerDirs dirs) {
        String oldBalayagesPath;
        File etcBalayageDir;
        File varBalayageDir = dirs.getSubPath("var.data", "balayagedata");
        if (!varBalayageDir.exists() && (etcBalayageDir = dirs.getSubPath("etc.", oldBalayagesPath = dirs.getName().equals("_unique") ? "balayages" : dirs.getName() + "/balayages")).exists()) {
            try {
                FileUtils.copyDirectory(etcBalayageDir, varBalayageDir, true);
            }
            catch (IOException ioe) {
                throw new BdfStorageException(ioe);
            }
        }
    }
}

