/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.jsonproducers;

import fr.exemole.bdfserver.multi.MultiUtils;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.api.central.CentralSphere;
import fr.exemole.bdfserver.multi.api.central.CentralUser;
import fr.exemole.bdfserver.multi.jsonproducers.MultiJsonProducer;
import fr.exemole.bdfserver.multi.jsonproducers.admin.FichothequeArrayJsonProperty;
import fr.exemole.bdfserver.multi.jsonproducers.admin.MultiMetadataJsonProperty;
import fr.exemole.bdfserver.multi.jsonproducers.admin.PersonJsonProperty;
import fr.exemole.bdfserver.multi.jsonproducers.central.CentralSphereMetadataJsonProperty;
import fr.exemole.bdfserver.multi.jsonproducers.central.CentralSphereStatsJsonProperty;
import fr.exemole.bdfserver.multi.jsonproducers.central.CentralUserArrayJsonProperty;
import fr.exemole.bdfserver.multi.jsonproducers.central.CentralUserJsonProperty;
import fr.exemole.bdfserver.multi.jsonproducers.central.PresenceJsonProperty;
import fr.exemole.bdfserver.multi.jsonproducers.central.UserStateJsonProperty;
import fr.exemole.bdfserver.multi.tools.PresenceInfo;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.synthesis.RedacteurSynthesis;
import fr.exemole.bdfserver.tools.synthesis.SphereSynthesis;
import java.text.ParseException;
import java.util.List;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.json.JsonProperty;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.localisation.UserLangContext;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public final class MultiJsonProducerFactory {
    private MultiJsonProducerFactory() {
    }

    public static MultiJsonProducer getJsonProducer(Multi multi, String json, RequestMap requestMap, CentralUser authentifiedCentralUser) {
        JsonProducerBuilder builder = new JsonProducerBuilder(multi, requestMap, authentifiedCentralUser);
        builder.appendProperties(json);
        return builder.toJsonProducer();
    }

    public static MultiJsonProducer getJsonProducer(Multi multi, String json, RequestMap requestMap, CommandMessage commandMessage) {
        JsonProducerBuilder builder = new JsonProducerBuilder(multi, requestMap);
        builder.setCommandMessage(commandMessage);
        builder.appendProperties(json);
        return builder.toJsonProducer();
    }

    public static MultiJsonProducer unauthentified(Multi multi) {
        return new MultiJsonProducer(false, multi.getAdminMessageLocalisation());
    }

    private static boolean needMultiAdminAuthentified(String json) {
        switch (json) {
            case "presence": 
            case "ping": 
            case "": {
                return false;
            }
        }
        return true;
    }

    private static class JsonProducerBuilder {
        private final Multi multi;
        private final RequestMap requestMap;
        private final MessageLocalisation messageLocalisation;
        private final Lang lang;
        private final MultiJsonProducer jsonProducer;
        private final boolean multiAdminAuthentified;
        private CentralSphere centralSphere = null;
        private CentralUser centralUser = null;
        private boolean withCommandMessage = false;

        private JsonProducerBuilder(Multi multi, RequestMap requestMap) {
            this.multi = multi;
            this.requestMap = requestMap;
            this.messageLocalisation = multi.getAdminMessageLocalisation();
            this.lang = multi.getAdminLang();
            this.jsonProducer = new MultiJsonProducer(true, this.messageLocalisation);
            this.multiAdminAuthentified = true;
        }

        private JsonProducerBuilder(Multi multi, RequestMap requestMap, CentralUser authentifiedUser) {
            this.multi = multi;
            this.requestMap = requestMap;
            UserLangContext userLangContext = authentifiedUser.getUserLangContext();
            this.messageLocalisation = multi.getMessageLocalisationProvider().getMessageLocalisation(userLangContext.getLangPreference());
            this.lang = userLangContext.getWorkingLang();
            this.jsonProducer = new MultiJsonProducer(true, this.messageLocalisation);
            this.centralUser = authentifiedUser;
            this.centralSphere = multi.getCentralSphere(authentifiedUser.getLoginKey().getSphereName());
            this.multiAdminAuthentified = false;
        }

        private void setCommandMessage(CommandMessage commandMessage) {
            if (commandMessage != null) {
                this.jsonProducer.setCommandMessage(commandMessage);
                this.withCommandMessage = true;
            }
        }

        private CentralSphere getCentralSphere() throws ErrorMessageException {
            if (this.centralSphere == null) {
                this.centralSphere = MultiUtils.getCentralSphere(this.multi, this.requestMap);
            }
            return this.centralSphere;
        }

        private CentralUser getCentralUser() throws ErrorMessageException {
            if (this.centralUser == null) {
                this.centralUser = MultiUtils.getCentralUser(this.multi, this.requestMap);
            }
            return this.centralUser;
        }

        private void appendProperties(String json) {
            String[] jsonTokens = StringUtils.getTechnicalTokens(json, true);
            boolean done = false;
            try {
                block27: for (String jsonToken : jsonTokens) {
                    if (MultiJsonProducerFactory.needMultiAdminAuthentified(jsonToken) && !this.multiAdminAuthentified) continue;
                    switch (jsonToken) {
                        case "fichotheque-array": {
                            this.jsonProducer.add(new FichothequeArrayJsonProperty(this.multi, this.messageLocalisation, this.lang));
                            done = true;
                            continue block27;
                        }
                        case "multimetadata": {
                            this.jsonProducer.add(new MultiMetadataJsonProperty(this.multi));
                            done = true;
                            continue block27;
                        }
                        case "person": {
                            this.jsonProducer.add(this.getPersonJsonProperty());
                            done = true;
                            continue block27;
                        }
                        case "centralspheremetadata": {
                            this.jsonProducer.add(new CentralSphereMetadataJsonProperty(this.getCentralSphere()));
                            done = true;
                            continue block27;
                        }
                        case "centralspherestats": {
                            this.jsonProducer.add(new CentralSphereStatsJsonProperty(this.multi, this.getCentralSphere(), this.lang));
                            done = true;
                            continue block27;
                        }
                        case "user": {
                            this.jsonProducer.add(new CentralUserJsonProperty(this.getCentralUser()));
                            done = true;
                            continue block27;
                        }
                        case "user-array": {
                            this.jsonProducer.add(new CentralUserArrayJsonProperty(this.getCentralSphere()));
                            done = true;
                            continue block27;
                        }
                        case "userstate": {
                            this.jsonProducer.add(new UserStateJsonProperty(this.multi, this.getCentralUser(), this.lang));
                            done = true;
                            continue block27;
                        }
                        case "presence": {
                            List<PresenceInfo> list = PresenceInfo.scan(this.multi, this.getCentralUser(), false);
                            this.jsonProducer.add(new PresenceJsonProperty(list, this.lang));
                            done = true;
                            continue block27;
                        }
                        case "": 
                        case "ping": {
                            done = true;
                        }
                    }
                }
                if (!done && !this.withCommandMessage) {
                    throw new ErrorMessageException("_ error.unknown.json", json);
                }
            }
            catch (ErrorMessageException eme) {
                this.jsonProducer.setCommandMessage(eme.getErrorMessage());
            }
        }

        private JsonProperty getPersonJsonProperty() throws ErrorMessageException {
            SubsetKey sphereKey;
            if (!this.multi.isPersonManagementAllowed()) {
                throw new ErrorMessageException("_ error.unsupported.personmanagementnotallowed");
            }
            String sphereName = this.requestMap.getParameter("sphere");
            if (sphereName == null) {
                throw BdfErrors.emptyMandatoryParameter("sphere");
            }
            String login = this.requestMap.getParameter("login");
            if (login == null) {
                throw BdfErrors.emptyMandatoryParameter("login");
            }
            try {
                sphereKey = SubsetKey.parse((short)3, sphereName.trim());
            }
            catch (ParseException pe) {
                throw new ErrorMessageException("_ error.unknown.sphere", sphereName);
            }
            SphereSynthesis sphereSynthesis = MultiUtils.getSphereSynthesis(this.multi, sphereKey);
            if (sphereSynthesis.getFichothequeSize() == 0) {
                throw new ErrorMessageException("_ error.unknown.sphere", sphereName);
            }
            RedacteurSynthesis redacteurSynthesis = sphereSynthesis.getRedacteurSynthesis(login);
            if (redacteurSynthesis == null) {
                throw new ErrorMessageException("_ error.unknown.redacteur", login);
            }
            return new PersonJsonProperty(this.multi, sphereSynthesis, redacteurSynthesis, this.multi.getAdminLang());
        }

        private MultiJsonProducer toJsonProducer() {
            return this.jsonProducer;
        }
    }
}

