/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.htmlproducers;

import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.html.consumers.Grid;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.consumers.attributes.Deploy;
import fr.exemole.bdfserver.html.consumers.attributes.InputPattern;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.htmlproducers.MultiHtmlProducer;
import java.util.Set;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.request.RequestUtils;

public class IniFormHtmlProducer
extends MultiHtmlProducer {
    private final RequestMap requestMap;

    public IniFormHtmlProducer(Multi multi, RequestMap requestMap) {
        super(multi, RequestUtils.getDefaultLang(requestMap));
        this.requestMap = requestMap;
        this.addJsLib(BdfJsLibs.DEPLOY);
        this.addThemeCss("multiini.css");
    }

    @Override
    public void printHtml() {
        this.startLoc("_ title.multi.ini");
        this.MAIN("multiini-Main").__(PageUnit.start("action-Init", "_ title.multi.ini")).__(this.printCommandMessage()).__(this.printForm()).__(PageUnit.END)._MAIN();
        this.end();
    }

    private boolean printForm() {
        Set<String> centralSphereNameSet = this.getCentralSphereNameSet();
        this.FORM_post("multi-admin").INPUT_hidden("cmd", "Ini").__(Grid.START).__(Grid.textInputRow("_ label.multi.adminlogin", this.input("login").populate(InputPattern.LOGIN).required(true))).__(Grid.passwordInputRow("_ label.multi.adminpassword_1", this.name("password_1").size("15").required(true))).__(Grid.passwordInputRow("_ label.multi.adminpassword_2", this.name("password_2").size("15").required(true))).__(Grid.textInputRow("_ label.multi.defaultlang", this.input("lang").populate(InputPattern.LANG).required(true))).__(Grid.textInputRow("_ label.multi.authority", this.input("authority").populate(InputPattern.AUTHORITY).required(true))).__(this.printCentralSphereRow(centralSphereNameSet)).__(Grid.END).__(this.printFichothequeTest()).__(Button.COMMAND, Button.submit("action-Init", "_ submit.multi.ini"))._FORM();
        return true;
    }

    private boolean printCentralSphereRow(Set<String> centralSphereNameSet) {
        if (centralSphereNameSet == null || centralSphereNameSet.isEmpty()) {
            return false;
        }
        String locKey = centralSphereNameSet.size() > 1 ? "_ label.multi.centralspheres" : "_ label.multi.centralsphere";
        StringBuilder buf = new StringBuilder();
        for (String name : centralSphereNameSet) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(name);
        }
        this.__(Grid.START_ROW).__(Grid.labelCells(locKey)).__(Grid.START_INPUTCELL).__escape(buf.toString()).__(Grid.END_INPUTCELL).__(Grid.END_ROW);
        return true;
    }

    private boolean printFichothequeTest() {
        switch (this.multi.getAuthentificationSharing()) {
            case "strict": {
                Set<String> centralSphereNameSet = this.multi.getCentralSphereNameSet();
                if (centralSphereNameSet.isEmpty()) {
                    this.P("global-WarningMessage").__localize("_ warning.multi.nocentralsphere")._P();
                    this.printFichothequeCreation();
                    return true;
                }
                return false;
            }
        }
        return this.printFichothequeCreation();
    }

    private boolean printFichothequeCreation() {
        if (!this.multi.isEmpty()) {
            return false;
        }
        boolean checked = this.requestMap.isTrue("createfichotheque");
        String targetId = this.generateId();
        this.DIV("multiini-Fichotheque").__(Grid.START).__(Grid.checkboxRow((Object)"_ label.multi.createfichotheque", this.name("createfichotheque").checked(checked).value("1").populate(Deploy.checkbox(targetId)), () -> this.DIV(Grid.detailPanelTable().id(targetId).addClass(!checked, "hidden")).__(Grid.textInputRow("_ label.multi.fichothequename", this.input("newfichotheque").populate(InputPattern.TECHNICAl_UNDERSCORE).populate(Deploy.REQUIRED))).__(Grid.textInputRow("_ label.multi.firstsphere", this.input("firstsphere").populate(InputPattern.TECHNICAL_STRICT).populate(Deploy.REQUIRED))).__(Grid.textInputRow("_ label.multi.firstuser", this.input("firstuser").populate(InputPattern.LOGIN).populate(Deploy.REQUIRED))).__(Grid.passwordInputRow("_ label.multi.firstpassword_1", this.name("firstpassword_1").size("15").populate(Deploy.REQUIRED))).__(Grid.passwordInputRow("_ label.multi.firstpassword_2", this.name("firstpassword_2").size("15").populate(Deploy.REQUIRED)))._DIV())).__(Grid.END)._DIV();
        return true;
    }

    private Set<String> getCentralSphereNameSet() {
        switch (this.multi.getAuthentificationSharing()) {
            case "strict": {
                return this.multi.getCentralSphereNameSet();
            }
        }
        return null;
    }

    private HtmlAttributes input(String name) {
        HtmlAttributes attr = this.name(name);
        String value = this.requestMap.getParameter(name);
        value = value == null ? this.getDefault(name) : value.trim();
        return attr.value(value).size(this.getSize(name));
    }

    private String getDefault(String name) {
        switch (name) {
            case "authority": {
                return "localhost";
            }
            case "login": {
                return "admin";
            }
            case "firstsphere": {
                return "admin";
            }
            case "firstuser": {
                return "ADMIN";
            }
            case "lang": {
                return RequestUtils.getDefaultLang(this.requestMap).toString();
            }
        }
        return "";
    }

    private String getSize(String name) {
        switch (name) {
            case "lang": {
                return "5";
            }
        }
        return "15";
    }
}

