/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.multi.commands.fichotheque;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.multi.MultiUtils;
import fr.exemole.bdfserver.multi.api.Multi;
import fr.exemole.bdfserver.multi.api.MultiMetadata;
import fr.exemole.bdfserver.multi.commands.AbstractMultiCommand;
import fr.exemole.bdfserver.multi.commands.CreationParameters;
import fr.exemole.bdfserver.storage.directory.bdfdata.StartValues;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import java.util.LinkedHashSet;
import java.util.Set;
import net.fichotheque.SubsetKey;
import net.fichotheque.utils.SphereUtils;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class FichothequeCreationCommand
extends AbstractMultiCommand {
    public static final String COMMAND_NAME = "FichothequeCreation";
    public static final String NEWFICHOTHEQUE_PARAMNAME = "newfichotheque";
    public static final String SPHEREORIGIN_PARAMNAME = "sphereorigin";
    public static final String CENTRALSPHERE_PARAMNAME = "centralsphere";
    public static final String FIRSTSPHERE_PARAMNAME = "firstsphere";
    public static final String FIRSTUSER_PARAMNAME = "firstuser";
    public static final String FIRSTPASSWORD1_PARAMNAME = "firstpassword_1";
    public static final String FIRSTPASSWORD2_PARAMNAME = "firstpassword_2";
    public static final String COPYORIGIN_PARAMNAME = "copyorigin";
    public static final String CREATION_SPHEREORIGIN_PARAMVALUE = "creation";
    public static final String CENTRAL_SPHEREORIGIN_PARAMVALUE = "central";
    public static final String COPY_SPHEREORIGIN_PARAMVALUE = "copy";

    public FichothequeCreationCommand(Multi multi, RequestMap requestMap) {
        super(multi, requestMap);
    }

    @Override
    public CommandMessage doCommand() throws ErrorMessageException {
        String name = this.run();
        return this.done("_ done.multi.fichothequecreation", name);
    }

    private String run() throws ErrorMessageException {
        String name = this.getFichothequeName(NEWFICHOTHEQUE_PARAMNAME);
        if (this.multi.containsFichotheque(name)) {
            throw new ErrorMessageException("_ error.existing.fichotheque", name);
        }
        switch (this.getMandatory(SPHEREORIGIN_PARAMNAME)) {
            case "copy": {
                this.runCopy(name);
                break;
            }
            case "central": {
                this.runCentral(name);
                break;
            }
            default: {
                this.runCreation(name);
            }
        }
        return name;
    }

    private void runCreation(String name) throws ErrorMessageException {
        MultiMetadata multiMetadata = this.multi.getMultiMetadata();
        StartValues startValues = FichothequeCreationCommand.getStartValues(this.requestMap).authority(multiMetadata.getAuthority()).basename(name).workingLangs(multiMetadata.getWorkingLangs());
        this.multi.createFichotheque(CreationParameters.initNew(name, startValues));
    }

    private void runCopy(String name) throws ErrorMessageException {
        String copyOrigin = this.getMandatory(COPYORIGIN_PARAMNAME);
        if (!this.multi.isInit(copyOrigin)) {
            throw new ErrorMessageException("_ error.unknown.parametervalue", COPYORIGIN_PARAMNAME, copyOrigin);
        }
        BdfServer sourceBdfServer = this.multi.getBdfServer(copyOrigin);
        MultiMetadata multiMetadata = this.multi.getMultiMetadata();
        StartValues startValues = StartValues.init().authority(multiMetadata.getAuthority()).basename(name).workingLangs(multiMetadata.getWorkingLangs());
        this.multi.createFichotheque(CreationParameters.initNewWithSpheres(name, startValues, sourceBdfServer));
    }

    private void runCentral(String name) throws ErrorMessageException {
        String[] centralSphereArray = this.requestMap.getParameterValues(CENTRALSPHERE_PARAMNAME);
        if (centralSphereArray == null || centralSphereArray.length == 0) {
            throw BdfErrors.emptyMandatoryParameter(CENTRALSPHERE_PARAMNAME);
        }
        Set<String> centralSphereNameSet = this.multi.getCentralSphereNameSet();
        LinkedHashSet<String> copySet = new LinkedHashSet<String>();
        for (String centralSphere : centralSphereArray) {
            if (!centralSphereNameSet.contains(centralSphere)) continue;
            copySet.add(centralSphere);
        }
        if (copySet.isEmpty()) {
            throw BdfErrors.unknownParameterValue(CENTRALSPHERE_PARAMNAME, centralSphereArray[0]);
        }
        MultiMetadata multiMetadata = this.multi.getMultiMetadata();
        StartValues startValues = StartValues.init().authority(multiMetadata.getAuthority()).basename(name).workingLangs(multiMetadata.getWorkingLangs());
        for (String sphereName : copySet) {
            startValues.addCentralSphere(sphereName);
        }
        this.multi.createFichotheque(CreationParameters.initNewWithCentral(name, startValues));
    }

    public static StartValues getStartValues(RequestMap requestMap) throws ErrorMessageException {
        SubsetKey sphereKey;
        String sphereName = MultiUtils.getMandatory(requestMap, FIRSTSPHERE_PARAMNAME);
        String firstUser = MultiUtils.getMandatory(requestMap, FIRSTUSER_PARAMNAME);
        String password1 = MultiUtils.getMandatory(requestMap, FIRSTPASSWORD1_PARAMNAME);
        String password2 = MultiUtils.getMandatory(requestMap, FIRSTPASSWORD2_PARAMNAME);
        try {
            sphereKey = SubsetKey.parse((short)3, sphereName);
        }
        catch (ParseException pe) {
            throw new ErrorMessageException("_ error.wrong.spherename", sphereName);
        }
        if (!SphereUtils.testLogin(firstUser)) {
            throw new ErrorMessageException("_ error.wrong.login", firstUser);
        }
        if (!password1.equals(password2)) {
            throw new ErrorMessageException("_ error.wrong.password_different");
        }
        return StartValues.init().spherename(sphereKey.getSubsetName()).firstuser(firstUser).firstpassword(password1);
    }
}

