/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.impl;

import fr.exemole.bdfserver.api.roles.Permission;
import fr.exemole.bdfserver.api.roles.Role;
import fr.exemole.bdfserver.api.roles.RoleDef;
import fr.exemole.bdfserver.tools.roles.RoleUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.attr.AttributesCache;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.LabelsCache;

class RoleImpl
implements Role {
    private final String name;
    private final boolean isDefault;
    private final LabelsCache labelsCache = new LabelsCache();
    private final AttributesCache attributesCache = new AttributesCache();
    private final Map<SubsetKey, Permission> subsetPermissionMap = new LinkedHashMap<SubsetKey, Permission>();
    private List<RoleDef.SubsetEntry> cacheList;

    private RoleImpl(String name) {
        this.name = name;
        this.isDefault = name.equals("_default");
    }

    @Override
    public Permission getPermissionBySubsetKey(SubsetKey subsetKey) {
        return this.subsetPermissionMap.get(subsetKey);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<RoleDef.SubsetEntry> getSubsetEntryList() {
        List<RoleDef.SubsetEntry> result = this.cacheList;
        if (result == null) {
            result = this.initSubsetEntryList();
        }
        return result;
    }

    @Override
    public Labels getTitleLabels() {
        return this.labelsCache.getLabels();
    }

    @Override
    public Attributes getAttributes() {
        return this.attributesCache.getAttributes();
    }

    void putSubsetPermission(SubsetKey subsetKey, Permission permission) {
        if (this.isDefault) {
            if (permission.getLevel() == 1) {
                this.removeSubsetPermission(subsetKey);
                return;
            }
        } else if (permission.getLevel() == 0) {
            this.removeSubsetPermission(subsetKey);
            return;
        }
        this.subsetPermissionMap.put(subsetKey, permission);
        this.clearCache();
    }

    void removeSubsetPermission(SubsetKey subsetKey) {
        this.subsetPermissionMap.remove(subsetKey);
        this.clearCache();
    }

    private synchronized List<RoleDef.SubsetEntry> initSubsetEntryList() {
        if (this.cacheList != null) {
            return this.cacheList;
        }
        ArrayList<RoleDef.SubsetEntry> tempList = new ArrayList<RoleDef.SubsetEntry>();
        for (Map.Entry<SubsetKey, Permission> entry : this.subsetPermissionMap.entrySet()) {
            tempList.add(RoleUtils.toSubsetEntry(entry.getKey(), entry.getValue()));
        }
        List<RoleDef.SubsetEntry> newList = RoleUtils.wrap(tempList.toArray(new RoleDef.SubsetEntry[tempList.size()]));
        this.cacheList = newList;
        return newList;
    }

    private void clearCache() {
        this.cacheList = null;
    }

    boolean putLabel(Label label) {
        return this.labelsCache.putLabel(label);
    }

    boolean removeLabel(Lang lang) {
        return this.labelsCache.removeLabel(lang);
    }

    boolean removeAttribute(AttributeKey attributeKey) {
        return this.attributesCache.removeAttribute(attributeKey);
    }

    boolean putAttribute(Attribute attribute) {
        return this.attributesCache.putAttribute(attribute);
    }

    static RoleImpl fromRoleDef(RoleDef roleDef) {
        RoleImpl role = new RoleImpl(roleDef.getName());
        for (RoleDef.SubsetEntry entry : roleDef.getSubsetEntryList()) {
            role.putSubsetPermission(entry.getSubsetKey(), entry.getPermission());
        }
        role.labelsCache.putLabels(roleDef.getTitleLabels());
        role.attributesCache.putAttributes(roleDef.getAttributes());
        return role;
    }

    static RoleImpl fromName(String roleName) {
        return new RoleImpl(roleName);
    }
}

