/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.thesaurus;

import fr.exemole.bdfserver.api.externalsource.ExternalSourceType;
import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfHtmlUtils;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.Grid;
import fr.exemole.bdfserver.html.consumers.attributes.Deploy;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.htmlproducers.CommandBoxUtils;
import fr.exemole.bdfserver.htmlproducers.thesaurus.ThesaurusCommandBoxUtils;
import fr.exemole.bdfserver.htmlproducers.thesaurus.ThesaurusHtmlUtils;
import fr.exemole.bdfserver.tools.externalsource.ExternalSourceUtils;
import java.util.List;
import net.fichotheque.SubsetKey;
import net.fichotheque.externalsource.ExternalSourceDef;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.policies.DynamicEditPolicy;
import net.fichotheque.utils.FichothequeUtils;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.html.CommandBox;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.localisation.Litteral;

public class ThesaurusMetadataFormHtmlProducer
extends BdfServerHtmlProducer {
    private final PermissionSummary permissionSummary;
    private final Thesaurus thesaurus;

    public ThesaurusMetadataFormHtmlProducer(BdfParameters bdfParameters, Thesaurus thesaurus) {
        super(bdfParameters);
        this.permissionSummary = bdfParameters.getPermissionSummary();
        this.thesaurus = thesaurus;
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addJsLib(BdfJsLibs.COMMANDVEIL);
        this.addJsLib(BdfJsLibs.DEPLOY);
        this.addJsLib(BdfJsLibs.SUBSETCHANGE);
        this.addThemeCss("thesaurus.css");
    }

    @Override
    public void printHtml() {
        this.start();
        BdfHtmlUtils.printSubsetHeader(this, this.bdfParameters, this.thesaurus, "thesaurus-metadataform");
        ThesaurusHtmlUtils.printThesaurusToolbar(this, "thesaurus-metadataform", this.thesaurus);
        this.printCommandMessageUnit();
        CommandBox commandBox = CommandBox.init().action("thesaurus").family("THS").veil(true).page("thesaurus-metadataform");
        ThesaurusCommandBoxUtils.printThesaurusPhrasesBox(this, commandBox, this.thesaurus, this.bdfServer);
        ThesaurusCommandBoxUtils.printThesaurusLangListBox(this, commandBox, this.thesaurus, this.bdfServer);
        if (this.permissionSummary.isFichothequeAdmin()) {
            this.printPolicy(commandBox);
        }
        this.end();
    }

    private void printPolicy(CommandBox commandBox) {
        DynamicEditPolicy policy = this.bdfServer.getPolicyManager().getPolicyProvider().getDynamicEditPolicy(this.thesaurus);
        commandBox = commandBox.derive("ThesaurusPolicy", "_ THS-05").__(CommandBoxUtils.insert(this.thesaurus)).submitLocKey("_ submit.thesaurus.thesauruspolicy");
        this.__start(commandBox).__(Grid.START).__(this.printNoneRadio(policy)).__(this.printSupplementaryPolicies(policy)).__(this.printExternalRadio(policy)).__(Grid.END).__end(commandBox);
    }

    private boolean printSupplementaryPolicies(DynamicEditPolicy policy) {
        switch (this.thesaurus.getThesaurusMetadata().getThesaurusType()) {
            case "multi": {
                List<Thesaurus> babelienList = ThesaurusUtils.getBabelienThesaurusList(this.bdfServer.getFichotheque());
                if (babelienList.isEmpty()) {
                    return false;
                }
                SubsetKey currentTransferKey = null;
                if (policy.getType().equals("transfer")) {
                    currentTransferKey = ((DynamicEditPolicy.Transfer)policy).getTransferThesaurusKey();
                }
                this.__(this.printTransferRadio(currentTransferKey, babelienList));
                return true;
            }
            case "babelien": {
                List<Thesaurus> babelienList = ThesaurusUtils.getBabelienThesaurusList(this.bdfServer.getFichotheque());
                List<Thesaurus> noIdalphaList = ThesaurusUtils.getNoIdalphaThesaurusList(this.bdfServer.getFichotheque());
                this.__if(babelienList.size() >= 0, () -> {
                    SubsetKey currentTransferKey = null;
                    if (policy.getType().equals("transfer")) {
                        currentTransferKey = ((DynamicEditPolicy.Transfer)policy).getTransferThesaurusKey();
                    }
                    this.__(this.printTransferRadio(currentTransferKey, babelienList));
                }).__(this.printAllowRadio(policy)).__if(noIdalphaList.size() >= 0, () -> this.__(this.printCheckRadio(this.getCheckList(policy), noIdalphaList)));
                return true;
            }
        }
        return false;
    }

    private boolean printPolicyRadio(String policyValue, boolean checked, String messageKey) {
        HtmlAttributes radio = this.policyRadio(policyValue).checked(checked);
        this.__(Grid.radioRow(messageKey, radio));
        return true;
    }

    private boolean printNoneRadio(DynamicEditPolicy policy) {
        boolean checked = policy.getType().equals("none");
        return this.printPolicyRadio("none", checked, "_ label.thesaurus.policy_none");
    }

    private boolean printAllowRadio(DynamicEditPolicy policy) {
        boolean checked = policy.getType().equals("allow");
        return this.printPolicyRadio("allow", checked, "_ label.thesaurus.policy_allow");
    }

    private boolean printTransferRadio(SubsetKey currentTransferKey, List<Thesaurus> transferList) {
        String detailId = this.generateId();
        boolean checked = currentTransferKey != null;
        HtmlAttributes radio = this.policyRadio("transfer").checked(checked).populate(Deploy.radio(detailId));
        this.__(Grid.radioRow((Object)"_ label.thesaurus.policy_transfer", radio, () -> this.DIV(Grid.detailPanelTable().id(detailId).addClass(!checked, "hidden")).__(Grid.selectRow((Object)"_ label.global.thesaurus", this.name("transferkey"), () -> {
            for (Thesaurus transferThesaurus : transferList) {
                SubsetKey transferKey = transferThesaurus.getSubsetKey();
                this.OPTION(transferKey.getSubsetName(), currentTransferKey != null && transferKey.equals(currentTransferKey)).__escape(FichothequeUtils.getTitleWithKey(transferThesaurus, this.workingLang))._OPTION();
            }
        }))._DIV()));
        return true;
    }

    private boolean printCheckRadio(List<SubsetKey> currentList, List<Thesaurus> availableList) {
        String detailId = this.generateId();
        boolean checked = currentList != null;
        HtmlAttributes radio = this.policyRadio("check").checked(checked).populate(Deploy.radio(detailId));
        this.__(Grid.radioRow((Object)"_ label.thesaurus.policy_check", radio, () -> this.DIV(Grid.detailPanelTable().id(detailId).addClass(!checked, "hidden")).__(Grid.selectRow((Object)"_ label.global.thesaurus", this.name("checkkeylist").size("5").multiple(true), () -> {
            for (Thesaurus availableThesaurus : availableList) {
                SubsetKey availableKey = availableThesaurus.getSubsetKey();
                this.OPTION(availableKey.getSubsetName(), currentList != null && currentList.contains(availableKey)).__escape(FichothequeUtils.getTitleWithKey(availableThesaurus, this.workingLang))._OPTION();
            }
        }))._DIV()));
        return true;
    }

    private boolean printExternalRadio(DynamicEditPolicy policy) {
        ExternalSourceDef currentExternalSourceDef;
        List<ExternalSourceType> typeList = ExternalSourceUtils.getAvalaibleTypeList(this.bdfServer, this.thesaurus);
        boolean here = false;
        if (policy.getType().equals("external")) {
            currentExternalSourceDef = ((DynamicEditPolicy.External)policy).getExternalSourceDef();
            for (ExternalSourceType type : typeList) {
                if (!type.getName().equals(currentExternalSourceDef.getType())) continue;
                here = true;
            }
        } else {
            currentExternalSourceDef = null;
        }
        if (typeList.isEmpty() && currentExternalSourceDef == null) {
            return false;
        }
        boolean unknwonDef = currentExternalSourceDef != null && !here;
        String detailId = this.generateId();
        boolean checked = currentExternalSourceDef != null;
        HtmlAttributes radio = this.policyRadio("external").checked(checked).populate(Deploy.radio(detailId));
        this.__(Grid.radioRow((Object)"_ label.thesaurus.policy_external", radio, () -> {
            this.DIV(Grid.detailPanelTable().id(detailId).addClass(!checked, "hidden"));
            for (ExternalSourceType type : typeList) {
                this.__(this.printExternalType(type, currentExternalSourceDef));
            }
            if (unknwonDef) {
                this.printUnknownDef(currentExternalSourceDef);
            }
            this._DIV();
        }));
        return true;
    }

    private HtmlAttributes policyRadio(String policyValue) {
        return this.name("policy").value(policyValue);
    }

    private List<SubsetKey> getCheckList(DynamicEditPolicy policy) {
        if (!policy.getType().equals("check")) {
            return null;
        }
        return ((DynamicEditPolicy.Check)policy).getCheckSubseKeyList();
    }

    private boolean printExternalType(ExternalSourceType type, ExternalSourceDef currentExternalSourceDef) {
        Runnable runnable;
        boolean isCurrent = currentExternalSourceDef != null && currentExternalSourceDef.getType().equals(type.getName());
        String typeName = type.getName();
        String detailId = this.generateId();
        List<ExternalSourceType.Param> paramList = type.getParamList();
        HtmlAttributes radio = this.name("externaltype").value(typeName).checked(isCurrent);
        if (!paramList.isEmpty()) {
            radio.populate(Deploy.radio(detailId));
            runnable = () -> {
                this.DIV(Grid.detailPanelTable().id(detailId).addClass(!isCurrent, "hidden"));
                for (ExternalSourceType.Param param : paramList) {
                    String value = "";
                    if (isCurrent) {
                        value = currentExternalSourceDef.getParam(param.getName());
                    }
                    this.__(Grid.textInputRow(param.getL10nObject(), this.name("external_" + type.getName() + "|" + param.getName()).value(value)));
                }
                this._DIV();
            };
        } else {
            runnable = null;
        }
        this.__(Grid.radioRow(type.getL10nObject(), radio, runnable));
        return true;
    }

    private boolean printUnknownDef(ExternalSourceDef externalSourceDef) {
        String sourceType = externalSourceDef.getType();
        String detailId = this.generateId();
        HtmlAttributes radio = this.name("externaltype").value(sourceType).checked(true).populate(Deploy.radio(detailId));
        this.__(Grid.radioRow((Object)new Litteral(sourceType), radio, () -> {
            this.DIV(Grid.detailPanelTable().id(detailId));
            for (String paramName : externalSourceDef.getParamNameSet()) {
                String value = externalSourceDef.getParam(paramName);
                this.__(Grid.textInputRow(new Litteral(paramName), this.name("external_" + sourceType + "|" + paramName).value(value)));
            }
            this._DIV();
        }));
        return true;
    }
}

