/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.sphere;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.exportation.table.TableExportParameters;
import fr.exemole.bdfserver.api.managers.PermissionManager;
import fr.exemole.bdfserver.api.managers.TransformationManager;
import fr.exemole.bdfserver.api.namespaces.BdfUserSpace;
import fr.exemole.bdfserver.api.roles.Role;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.commands.sphere.LoginChangeCommand;
import fr.exemole.bdfserver.html.consumers.AttributesText;
import fr.exemole.bdfserver.html.consumers.Choices;
import fr.exemole.bdfserver.html.consumers.Common;
import fr.exemole.bdfserver.html.consumers.Grid;
import fr.exemole.bdfserver.html.consumers.MetadataPhrases;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.html.consumers.attributes.Appelant;
import fr.exemole.bdfserver.html.consumers.attributes.Deploy;
import fr.exemole.bdfserver.html.consumers.attributes.InputPattern;
import fr.exemole.bdfserver.html.consumers.commandbox.Flag;
import fr.exemole.bdfserver.html.forms.TableExportFormHtml;
import fr.exemole.bdfserver.htmlproducers.CommandBoxUtils;
import fr.exemole.bdfserver.tools.roles.RoleUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.fichotheque.Fichotheque;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.exportation.transformation.TemplateDescription;
import net.fichotheque.exportation.transformation.TransformationDescription;
import net.fichotheque.exportation.transformation.TransformationKey;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.sphere.metadata.SphereMetadata;
import net.fichotheque.tools.exportation.transformation.TransformationCheck;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.html.CommandBox;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangPreference;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.localisation.Litteral;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.PersonCore;

public final class SphereCommandBoxUtils {
    private SphereCommandBoxUtils() {
    }

    public static boolean printNotAllowed(HtmlPrinter hp, CommandBox commandBox, String commandKey) {
        return SphereCommandBoxUtils.printNotAvailableCommand(hp, commandBox, commandKey, "_ warning.sphere.multiadmin");
    }

    public static boolean printNotAvailableCommand(HtmlPrinter hp, CommandBox commandBox, String commandKey, String infoLocKey) {
        commandBox = commandBox.derive(null, commandKey);
        hp.__start(commandBox).P("sphere-NotAvailableInfo").__localize(infoLocKey)._P().__end(commandBox.lockey(null));
        return true;
    }

    public static boolean printSphereCreationBox(HtmlPrinter hp, CommandBox commandBox) {
        commandBox = commandBox.derive("SphereCreation", "_ SPH-01").actionCssClass("action-New").__(Flag.UPDATE_COLLECTIONS).submitLocKey("_ submit.sphere.spherecreation");
        hp.__start(commandBox).__(Grid.START).__(Grid.textInputRow("_ label.sphere.newspherename", hp.name("newsphere").size("30").populate(InputPattern.TECHNICAL_STRICT).required(true))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printSpherePhrasesBox(HtmlPrinter hp, CommandBox commandBox, Sphere sphere, BdfServer bdfServer) {
        SphereMetadata sphereMetadata = sphere.getSphereMetadata();
        commandBox = commandBox.derive("SpherePhrases", "_ SPH-02").__(CommandBoxUtils.insert(sphere)).actionCssClass("action-Labels").submitLocKey("_ submit.sphere.spherephrases");
        hp.__start(commandBox).__(MetadataPhrases.init(sphereMetadata, bdfServer.getLangConfiguration().getWorkingLangs(), "_ label.sphere.title").populateFromAttributes(sphere).addExtensionPhraseDefList(bdfServer)).__end(commandBox);
        return true;
    }

    public static boolean printSphereAttributeChangeBox(HtmlPrinter hp, CommandBox commandBox, Sphere sphere) {
        commandBox = commandBox.derive("SphereAttributeChange", "_ SPH-08").__(CommandBoxUtils.insert(sphere)).actionCssClass("action-Attributes").submitLocKey("_ submit.global.attributechange");
        hp.__start(commandBox).__(Grid.START).__(Grid.textAreaBlockRow((Object)"_ label.global.attributes", HA.name("attributes").rows(8).cols(75).attr("data-codemirror-mode", "attributes"), new AttributesText(sphere.getSphereMetadata().getAttributes()))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printSphereRemoveBox(HtmlPrinter hp, CommandBox commandBox, Sphere sphere) {
        commandBox = commandBox.derive("SphereRemove", "_ SPH-03").__(CommandBoxUtils.insert(sphere)).actionCssClass("action-Delete").__(Flag.UPDATE_COLLECTIONS).submitLocKey("_ submit.sphere.sphereremove");
        hp.__start(commandBox).__(Common.REMOVE_CONFIRM_CHECK).__end(commandBox);
        return true;
    }

    public static boolean printRedacteurCreationBox(HtmlPrinter hp, CommandBox commandBox, Sphere sphere) {
        commandBox = commandBox.derive("RedacteurCreation", "_ SPH-04").__(CommandBoxUtils.insert(sphere)).actionCssClass("action-New").submitLocKey("_ submit.sphere.redacteurcreation");
        hp.__start(commandBox).__(Grid.START).__(Grid.textInputRow("_ label.sphere.login", hp.name("newlogin").size("15").populate(InputPattern.LOGIN).required(true))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printLoginChangeBox(HtmlPrinter hp, CommandBox commandBox, Redacteur redacteur) {
        commandBox = commandBox.derive("LoginChange", "_ SPH-10").__(CommandBoxUtils.insert(redacteur)).submitLocKey("_ submit.sphere.loginchange");
        hp.__start(commandBox).__(Grid.START).__(Grid.textInputRow("_ label.sphere.login", hp.name(LoginChangeCommand.NEWLOGIN_PARAMNAME).value(redacteur.getLogin()).size("15").populate(InputPattern.LOGIN).required(true))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printRedacteurPasswordBox(HtmlPrinter hp, CommandBox commandBox, Redacteur redacteur) {
        commandBox = commandBox.derive("RedacteurPassword", "_ USR-03").__(CommandBoxUtils.insert(redacteur)).submitLocKey("_ submit.sphere.passwordchange");
        hp.__start(commandBox).__(Grid.START).__(Grid.passwordInputRow("_ label.sphere.password_1", hp.name("password1").size("20"))).__(Grid.passwordInputRow("_ label.sphere.password_2", hp.name("password2").size("20"))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printRedacteurChangeBox(HtmlPrinter hp, CommandBox commandBox, Redacteur redacteur, BdfServer bdfServer) {
        EmailCore email = redacteur.getEmailCore();
        PersonCore personCore = redacteur.getPersonCore();
        boolean withNonlatin = personCore.getNonlatin().length() > 0 || bdfServer.getLangConfiguration().isWithNonlatin();
        String emailValue = email != null ? email.toCompleteString() : "";
        commandBox = commandBox.derive("RedacteurChange", "_ USR-01").__(CommandBoxUtils.insert(redacteur)).submitLocKey("_ submit.sphere.redacteurchange");
        hp.__start(commandBox).__(Grid.START).__if(withNonlatin, () -> hp.__(Grid.textInputRow("_ label.sphere.nonlatin", hp.name("nonlatin").value(personCore.getNonlatin()).size("30")))).__(Grid.textInputRow(withNonlatin ? "_ label.sphere.surname_latin" : "_ label.sphere.surname", hp.name("surname").value(personCore.getSurname()).size("30"))).__(Grid.textInputRow(withNonlatin ? "_ label.sphere.forename_latin" : "_ label.sphere.forename", hp.name("forename").value(personCore.getForename()).size("30"))).__(SphereCommandBoxUtils.printSurnameFirstRow(hp, "surnamefirst", personCore.isSurnameFirst())).__(Grid.textInputRow("_ label.sphere.email", hp.name("email").value(emailValue).size("30"))).__(Grid.END).__end(commandBox);
        return true;
    }

    private static boolean printSurnameFirstRow(HtmlPrinter hp, String inputName, boolean checked) {
        String inputId = hp.generateId();
        hp.__(Grid.START_ROW).__(Grid.START_INPUTCELL).SPAN("command-FlexInput command-Smaller").INPUT_checkbox(HA.name(inputName).value("1").id(inputId).checked(checked)).LABEL_for(inputId).__localize("_ label.sphere.surnamefirst")._LABEL()._SPAN().__(Grid.END_INPUTCELL).__(Grid.END_ROW);
        return true;
    }

    public static boolean printLangBox(HtmlPrinter hp, CommandBox commandBox, Redacteur redacteur, BdfUser redacBdfUser, BdfServer bdfServer, Locale formatLocale) {
        Langs workingLangs = bdfServer.getLangConfiguration().getWorkingLangs();
        Lang currentLang = redacBdfUser.getWorkingLang();
        Locale customFormatLocale = redacBdfUser.getPrefs().getCustomFormatLocale();
        String customFormatLocaleValue = "";
        if (customFormatLocale != null) {
            customFormatLocaleValue = Lang.toISOString(customFormatLocale);
        }
        StringBuilder langPreferenceBuf = new StringBuilder();
        LangPreference customLangPreference = redacBdfUser.getPrefs().getCustomLangPreference();
        if (customLangPreference != null) {
            for (Lang lang : customLangPreference) {
                if (langPreferenceBuf.length() > 0) {
                    langPreferenceBuf.append(";");
                }
                langPreferenceBuf.append(lang);
            }
        }
        commandBox = commandBox.derive("RedacteurLang", "_ USR-02").__(CommandBoxUtils.insert(redacteur)).submitLocKey("_ submit.sphere.redacteurlang");
        hp.__start(commandBox).__(Grid.START).__(Grid.selectRow((Object)"_ label.sphere.workinglang", hp.name("workinglang"), () -> {
            for (Lang lang : workingLangs) {
                String langString = lang.toString();
                hp.OPTION(langString, lang.equals(currentLang)).__escape(langString).__dash();
                String voTitle = LocalisationUtils.getVOTitle(lang);
                if (voTitle != null) {
                    hp.__escape(voTitle);
                } else {
                    hp.__localize(langString);
                }
                hp._OPTION();
            }
        })).__(Grid.textInputRow("_ label.sphere.customformatlocale", hp.name("customformatlocale").value(customFormatLocaleValue).size("10"))).__(Grid.textInputRow("_ label.sphere.customlangpreference", hp.name("customlangpreference").value(langPreferenceBuf.toString()).size("30"))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printTemplatesBox(HtmlPrinter hp, CommandBox commandBox, BdfServer bdfServer, Lang workingLang, Redacteur redacteur, BdfUser redacBdfUser) {
        TransformationLists lists = new TransformationLists(bdfServer, workingLang, redacBdfUser);
        if (lists.isEmpty()) {
            hp.__(PageUnit.start("_ USR-04")).P().__localize("_ info.transformation.onlydefault")._P().__(PageUnit.END);
            return true;
        }
        commandBox = commandBox.derive("RedacteurTemplates", "_ USR-04").__(CommandBoxUtils.insert(redacteur)).submitLocKey("_ submit.sphere.redacteurtemplates");
        hp.__start(commandBox).__(lists.listSpecial()).__(lists.listCorpus()).__end(commandBox);
        return true;
    }

    public static boolean printDefaultTableExportParametersBox(HtmlPrinter hp, CommandBox commandBox, Redacteur redacteur, BdfUser redacBdfUser) {
        TableExportParameters tableExportParameters = redacBdfUser.getPrefs().getDefaultTableExportParameters();
        boolean checked = redacBdfUser.getPrefs().getBoolean(BdfUserSpace.TABLEEXPORT_STATUSSHEET_KEY);
        commandBox = commandBox.derive("RedacteurDefaultTableExportParameters", "_ USR-05").__(CommandBoxUtils.insert(redacteur)).submitLocKey("_ submit.sphere.redacteurdefaulttableexportparameters");
        hp.__start(commandBox).__(TableExportFormHtml.printWithParameters(hp, tableExportParameters.getDefaulFicheTableParameters())).__(TableExportFormHtml.printPatternModeRadios(hp, tableExportParameters.getDefaulFicheTableParameters().getPatternMode())).__(TableExportFormHtml.HEADERTYPE_TITLE).__(TableExportFormHtml.printHeaderTypeRadios(hp, tableExportParameters.getHeaderType())).__(TableExportFormHtml.ODSSPECIFIC_TITLE).__(Choices.LIST, () -> hp.__(Choices.checkboxLi(hp.name("statussheet").value("1").checked(checked), "_ label.tableexport.statussheet"))).__end(commandBox);
        return true;
    }

    public static boolean printCustomizeUIBox(HtmlPrinter hp, CommandBox commandBox, Redacteur redacteur, BdfUser redacBdfUser) {
        boolean noTab = redacBdfUser.getPrefs().getBoolean(BdfUserSpace.NOTAB_KEY);
        boolean hideEmpty = redacBdfUser.getPrefs().getBoolean(BdfUserSpace.HIDEEMPTY_KEY);
        boolean syntaxActive = redacBdfUser.getPrefs().getBoolean(BdfUserSpace.SYNTAXACTIVE_KEY);
        String dateInputs = redacBdfUser.getPrefs().getDateInputsType();
        commandBox = commandBox.derive("RedacteurCustomizeUI", "_ USR-06").__(CommandBoxUtils.insert(redacteur)).submitLocKey("_ submit.sphere.redacteurcustomizeui");
        hp.__start(commandBox).__(Grid.START).__(Grid.checkboxRow("_ label.sphere.notab", hp.name("notab").value("1").checked(noTab))).__(Grid.checkboxRow("_ label.sphere.hideempty", hp.name("hideempty").value("1").checked(hideEmpty))).__(Grid.checkboxRow("_ label.sphere.syntaxactive", hp.name("syntaxactive").value("1").checked(syntaxActive))).__(Grid.choiceSetRow((Object)"_ label.sphere.dateinputs", () -> hp.__(Grid.radioCell("_ label.sphere.dateinputs_iso", hp.name("dateinputs").value("iso").checked(dateInputs))).__(Grid.radioCell("_ label.sphere.dateinputs_inv", hp.name("dateinputs").value("inv").checked(dateInputs))).__(Grid.radioCell("_ label.sphere.dateinputs_usa", hp.name("dateinputs").value("usa").checked(dateInputs))))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printRedacteurRoleBox(HtmlPrinter hp, CommandBox commandBox, BdfServer bdfServer, Lang lang, Redacteur redacteur) {
        PermissionManager permissionManager = bdfServer.getPermissionManager();
        boolean isAdmin = permissionManager.isAdmin(redacteur);
        HashSet<String> redacteurRoleNameSet = new HashSet<String>();
        for (Role redacteurRole : permissionManager.getRoleList(redacteur)) {
            redacteurRoleNameSet.add(redacteurRole.getName());
        }
        String status = redacteur.getStatus();
        commandBox = commandBox.derive("RedacteurRole", "_ ROL-04").__(CommandBoxUtils.insert(redacteur)).submitLocKey("_ submit.sphere.redacteurrole");
        hp.__start(commandBox);
        if (status.equals("active")) {
            hp.__(Grid.START).__(Grid.checkboxRow("_ label.sphere.admin", hp.name("admin").value("1").checked(isAdmin))).__(Grid.END);
        }
        hp.H2().__localize("_ title.sphere.rolelist")._H2().__(Choices.SPACED_LIST, () -> {
            for (Role role : permissionManager.getRoleList()) {
                String roleName = role.getName();
                HtmlAttributes checkAttributes = hp.name("role").value(roleName).checked(redacteurRoleNameSet.contains(roleName));
                hp.__(Choices.checkboxLi(checkAttributes, () -> {
                    if (RoleUtils.isDefaultRole(role)) {
                        hp.EM().__localize("_ label.global.role_default")._EM();
                    } else {
                        hp.__escape('[').__escape(role.getName()).__escape(']');
                    }
                    hp.__space().__escape(role.getTitleLabels().seekLabelString(lang, ""));
                }));
            }
        }).__end(commandBox);
        return true;
    }

    public static boolean printRedacteurAttributeChangeBox(HtmlPrinter hp, CommandBox commandBox, Redacteur redacteur) {
        commandBox = commandBox.derive("RedacteurAttributeChange", "_ SPH-09").__(CommandBoxUtils.insert(redacteur)).actionCssClass("action-Attributes").submitLocKey("_ submit.global.attributechange");
        hp.__start(commandBox).__(Grid.START).__(Grid.textAreaBlockRow((Object)"_ label.global.attributes", hp.name("attributes").rows(8).cols(75).attr("data-codemirror-mode", "attributes"), new AttributesText(redacteur.getAttributes()))).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printRedacteurStatusBox(HtmlPrinter hp, CommandBox commandBox, Redacteur redacteur) {
        String status = redacteur.getStatus();
        commandBox = commandBox.derive("RedacteurStatus", "_ SPH-05").__(CommandBoxUtils.insert(redacteur)).submitLocKey("_ submit.sphere.redacteurstatus");
        hp.__start(commandBox).__(Grid.START).__(SphereCommandBoxUtils.printStatusRow(hp, "active", status)).__(SphereCommandBoxUtils.printStatusRow(hp, "readonly", status)).__(SphereCommandBoxUtils.printStatusRow(hp, "inactive", status)).__(Grid.END).__end(commandBox);
        return true;
    }

    public static boolean printRedacteurRemoveBox(HtmlPrinter hp, CommandBox commandBox, Redacteur redacteur) {
        commandBox = commandBox.derive("RedacteurRemove", "_ SPH-06").__(CommandBoxUtils.insert(redacteur)).submitLocKey("_ submit.sphere.redacteurremove");
        hp.__start(commandBox).__(Common.REMOVE_CONFIRM_CHECK).__end(commandBox);
        return true;
    }

    public static boolean printRedacteurReplaceBox(HtmlPrinter hp, CommandBox commandBox, Redacteur redacteur) {
        String otherId = hp.generateId();
        String litteralId = hp.generateId();
        commandBox = commandBox.derive("RedacteurReplace", "_ SPH-07").__(CommandBoxUtils.insert(redacteur)).submitLocKey("_ submit.sphere.redacteurreplace");
        hp.__start(commandBox).__(Grid.START).__(Grid.radioRow((Object)"_ label.sphere.otherlogin", hp.name("replacetype").value("other").checked(true).populate(Deploy.radio(otherId)), () -> {
            HtmlAttributes inputAttributes = hp.name("other").size("30").populate(Appelant.user().limit(1));
            hp.DIV(Grid.detailPanelTable().id(otherId)).__(Grid.textInputRow("_ label.global.value", inputAttributes))._DIV();
        })).__(Grid.radioRow((Object)"_ label.sphere.litteral", hp.name("replacetype").value("litteral").checked(false).populate(Deploy.radio(litteralId)), () -> hp.DIV(Grid.detailPanelTable().id(litteralId).addClass("hidden")).__(Grid.textInputRow("_ label.global.value", hp.name("litteral").size("30")))._DIV())).__(Grid.END).__(Common.REPLACE_CONFIRM_CHECK).__end(commandBox);
        return true;
    }

    private static String getTransformationMessageKey(TransformationKey transformationKey) {
        switch (transformationKey.getKeyString()) {
            case "compilation": {
                return "_ label.transformation.templates_compilation";
            }
            case "statthesaurus": {
                return "_ label.transformation.templates_statthesaurus";
            }
            case "inversethesaurus": {
                return "_ label.transformation.templates_inversethesaurus";
            }
            case "section": {
                return "_ label.transformation.templates_section";
            }
            case "format": {
                return "_ label.transformation.templates_format";
            }
            case "memento": {
                return "_ label.transformation.templates_memento";
            }
        }
        throw new SwitchException("Unknown transformationKey: " + transformationKey);
    }

    private static boolean printStatusRow(HtmlPrinter hp, String status, String currentStatus) {
        hp.__(Grid.radioRow(SphereCommandBoxUtils.getStatusMessageKey(status), hp.name("status").value(status).checked(currentStatus)));
        return true;
    }

    private static String getStatusMessageKey(String status) {
        switch (status) {
            case "active": {
                return "_ label.sphere.status_active";
            }
            case "readonly": {
                return "_ label.sphere.status_readonly";
            }
            case "inactive": {
                return "_ label.sphere.status_inactive";
            }
        }
        throw new SwitchException("Unknown status: " + status);
    }

    private static class TransformationLists
    implements Consumer<HtmlPrinter> {
        private final BdfServer bdfServer;
        private final BdfUser redacBdfUser;
        private final Lang workingLang;
        private final List<TransformationCheck> specialList = new ArrayList<TransformationCheck>();
        private final List<TransformationCheck> byCorpusList = new ArrayList<TransformationCheck>();
        private final List<Corpus> corpusList = new ArrayList<Corpus>();
        private final TransformationManager transformationManager;
        private boolean specialLists = false;

        private TransformationLists(BdfServer bdfServer, Lang workingLang, BdfUser redacBdfUser) {
            this.bdfServer = bdfServer;
            this.workingLang = workingLang;
            this.redacBdfUser = redacBdfUser;
            this.transformationManager = bdfServer.getTransformationManager();
            this.addSpecialTransformation(TransformationKey.COMPILATION_INSTANCE);
            this.addSpecialTransformation(TransformationKey.STATTHESAURUS_INSTANCE);
            Fichotheque fichotheque = bdfServer.getFichotheque();
            for (Corpus corpus : fichotheque.getCorpusList()) {
                TransformationDescription transformationDescription = this.transformationManager.getTransformationDescription(new TransformationKey(corpus.getSubsetKey()));
                TransformationCheck transformationCheck = TransformationCheck.check(transformationDescription, true);
                if (!transformationCheck.withTemplate()) continue;
                this.byCorpusList.add(transformationCheck);
                this.corpusList.add(corpus);
            }
        }

        private void addSpecialTransformation(TransformationKey transformationKey) {
            TransformationDescription transformationDescription = this.transformationManager.getTransformationDescription(transformationKey);
            TransformationCheck transformationCheck = TransformationCheck.check(transformationDescription, true);
            if (transformationCheck.withTemplate()) {
                this.specialList.add(transformationCheck);
            }
        }

        public boolean isEmpty() {
            return this.specialList.isEmpty() && this.byCorpusList.isEmpty();
        }

        public TransformationLists listSpecial() {
            this.specialLists = true;
            return this;
        }

        public TransformationLists listCorpus() {
            this.specialLists = false;
            return this;
        }

        @Override
        public void accept(HtmlPrinter hp) {
            if (this.specialLists) {
                if (!this.specialList.isEmpty()) {
                    hp.H2().__localize("_ title.transformation.specialkeys")._H2().__(Grid.START);
                    for (TransformationCheck transformationCheck : this.specialList) {
                        String title = hp.getLocalization(SphereCommandBoxUtils.getTransformationMessageKey(transformationCheck.getTransformationDescription().getTransformationKey()));
                        this.printTransformationCheck(hp, transformationCheck, title);
                    }
                    hp.__(Grid.END);
                }
            } else if (!this.byCorpusList.isEmpty()) {
                hp.H2().__localize("_ title.transformation.corpuskeys")._H2().__(Grid.START);
                int size = this.byCorpusList.size();
                for (int i = 0; i < size; ++i) {
                    TransformationCheck transformationCheck = this.byCorpusList.get(i);
                    Corpus corpus = this.corpusList.get(i);
                    String title = FichothequeUtils.getTitle(corpus, this.workingLang);
                    this.printTransformationCheck(hp, transformationCheck, title);
                }
                hp.__(Grid.END);
            }
        }

        private boolean printTransformationCheck(HtmlPrinter hp, TransformationCheck transformationCheck, String title) {
            if (transformationCheck.withSimpleTemplate()) {
                String templateName = this.redacBdfUser.getPrefs().getSimpleTemplateName(transformationCheck.getTransformationKey());
                if (templateName == null) {
                    templateName = "_default";
                }
                String currentName = templateName;
                hp.__(Grid.selectRow((Object)new Litteral(title), hp.name(transformationCheck.getTransformationKey().getKeyString()), () -> hp.__(this.printDefaultOption(hp, true, currentName)).__(this.printOptionArray(hp, transformationCheck.getSimpleTemplateDescriptionArray(), currentName))));
            } else {
                hp.__(Grid.START_ROW).__(Grid.labelCells(new Litteral(title))).__(Grid.END_ROW);
            }
            if (transformationCheck.withStreamTemplate()) {
                for (String extension : transformationCheck.getExtensionArray()) {
                    this.printStreamTemplateSelect(hp, transformationCheck, extension);
                }
            }
            return true;
        }

        private boolean printStreamTemplateSelect(HtmlPrinter hp, TransformationCheck transformationCheck, String extension) {
            TransformationKey transformationKey = transformationCheck.getTransformationKey();
            boolean isDefaultStreamTemplateAvailable = this.bdfServer.getTransformationManager().isDefaultStreamTemplateAvailable(transformationKey, extension);
            TemplateDescription[] templateDescriptionArray = transformationCheck.getStreamTemplateDescriptionArray(extension);
            String currentName = this.redacBdfUser.getPrefs().getStreamTemplateName(transformationKey, extension);
            if (currentName == null) {
                currentName = "_default";
            }
            if (!isDefaultStreamTemplateAvailable && currentName.equals("_default")) {
                currentName = templateDescriptionArray[0].getTemplateKey().getName();
            }
            HtmlAttributes selectAttributes = hp.name(transformationKey + "/" + extension);
            hp.__(Grid.START_ROW).__(Grid.START_INPUTCELL).SPAN().LABEL_for(selectAttributes.id()).__escape('.').__escape(extension).__colon()._LABEL().__space().SELECT(selectAttributes).__(this.printDefaultOption(hp, isDefaultStreamTemplateAvailable, currentName)).__(this.printOptionArray(hp, templateDescriptionArray, currentName))._SELECT()._SPAN().__(Grid.END_INPUTCELL).__(Grid.END_ROW);
            return true;
        }

        private boolean printDefaultOption(HtmlPrinter hp, boolean defaultAvailable, String currentName) {
            if (!defaultAvailable) {
                return false;
            }
            hp.OPTION("_default", currentName.equals("_default")).__localize("_ label.transformation.defaulttemplate")._OPTION();
            return true;
        }

        private boolean printOptionArray(HtmlPrinter hp, TemplateDescription[] templateDescriptionArray, String currentName) {
            for (TemplateDescription templateDescription : templateDescriptionArray) {
                hp.__(this.printOption(hp, templateDescription, currentName));
            }
            return true;
        }

        private boolean printOption(HtmlPrinter hp, TemplateDescription templateDescription, String currentName) {
            String templateName = templateDescription.getTemplateKey().getName();
            hp.OPTION(templateName, templateName.equals(currentName)).__escape(templateDescription.getTitle(this.workingLang))._OPTION();
            return true;
        }
    }
}

