/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.sphere;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.htmlproducers.sphere.SphereCommandBoxUtils;
import fr.exemole.bdfserver.htmlproducers.sphere.SphereHtmlUtils;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import net.fichotheque.sphere.Redacteur;
import net.mapeadores.util.html.CommandBox;

public class RedacteurPreferencesHtmlProducer
extends BdfServerHtmlProducer {
    private final Redacteur redacteur;
    private final BdfUser redacteurBdfUser;

    public RedacteurPreferencesHtmlProducer(BdfParameters bdfParameters, Redacteur redacteur) {
        super(bdfParameters);
        this.redacteur = redacteur;
        this.redacteurBdfUser = BdfUserUtils.isSame(this.bdfUser, redacteur) ? this.bdfUser : this.bdfServer.createBdfUser(redacteur);
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addJsLib(BdfJsLibs.COMMANDVEIL);
        this.addThemeCss("sphere.css");
    }

    @Override
    public void printHtml() {
        this.start();
        SphereHtmlUtils.printRedacteurToolbar(this, "redacteur-preferences", this.redacteur);
        this.printCommandMessageUnit();
        CommandBox commandBox = CommandBox.init().action("sphere").family("USR").veil(true).page("redacteur-preferences");
        SphereCommandBoxUtils.printLangBox(this, commandBox, this.redacteur, this.redacteurBdfUser, this.bdfServer, this.formatLocale);
        SphereCommandBoxUtils.printCustomizeUIBox(this, commandBox, this.redacteur, this.redacteurBdfUser);
        SphereCommandBoxUtils.printTemplatesBox(this, commandBox, this.bdfServer, this.bdfUser.getWorkingLang(), this.redacteur, this.redacteurBdfUser);
        SphereCommandBoxUtils.printDefaultTableExportParametersBox(this, commandBox, this.redacteur, this.redacteurBdfUser);
        this.end();
    }
}

