/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.misc;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.api.subsettree.GroupNode;
import fr.exemole.bdfserver.api.subsettree.SubsetNode;
import fr.exemole.bdfserver.api.subsettree.SubsetTree;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.consumers.PageUnit;
import fr.exemole.bdfserver.tools.subsettree.TreeUtils;
import net.fichotheque.corpus.Corpus;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;

public class DiagramsHtmlProducer
extends BdfServerHtmlProducer {
    private final SubsetTree corpusTree;

    public DiagramsHtmlProducer(BdfParameters bdfParameters) {
        super(bdfParameters);
        this.corpusTree = this.bdfServer.getTreeManager().getSubsetTree((short)1);
        this.addThemeCss("diagram.css", "misc.css");
    }

    @Override
    public void printHtml() {
        this.start();
        this.printCommandMessageUnit();
        if (this.corpusTree.getNodeList().isEmpty()) {
            this.end();
            return;
        }
        this.__(PageUnit.start("action-Diagrams", "_ title.misc.diagrams")).__(this.printGlobalDiagram());
        for (SubsetTree.Node node : this.corpusTree.getNodeList()) {
            if (node instanceof SubsetNode) {
                SubsetNode subsetNode = (SubsetNode)node;
                Corpus corpus = (Corpus)this.fichotheque.getSubset(subsetNode.getSubsetKey());
                this.__(this.printDiagram(corpus));
                continue;
            }
            if (!(node instanceof GroupNode)) continue;
            this.__(this.printGroupNodeForState((GroupNode)node));
        }
        this.__(PageUnit.END);
        this.end();
    }

    private boolean printGroupNodeForState(GroupNode groupNode) {
        this.P("diagram-GroupTitle").__escape(TreeUtils.getTitle(this.bdfServer, groupNode, this.workingLang))._P().DIV("diagram-GroupBlock");
        for (SubsetTree.Node node : groupNode.getSubnodeList()) {
            if (node instanceof SubsetNode) {
                SubsetNode subsetNode = (SubsetNode)node;
                Corpus corpus = (Corpus)this.fichotheque.getSubset(subsetNode.getSubsetKey());
                this.__(this.printDiagram(corpus));
                continue;
            }
            if (!(node instanceof GroupNode)) continue;
            this.__(this.printGroupNodeForState((GroupNode)node));
        }
        this._DIV();
        return true;
    }

    private boolean printDiagram(Corpus corpus) {
        String src = "diagrams/" + corpus.getSubsetKeyString();
        this.DIV("diagram-Corpus").DIV("diagram-Diagram").IMG(HA.src(src + ".png"))._DIV().P("diagram-Links").A(HA.href(src + ".png").target("_blank")).__escape("png")._A().__dash().A(HA.href(src + ".svg").target("_blank")).__escape("svg")._A().__dash().A(HA.href(src + ".puml").target("_blank")).__escape("puml")._A()._P()._DIV();
        return true;
    }

    private boolean printGlobalDiagram() {
        String src = "diagrams/fichotheque";
        HtmlAttributes ha = HA.href("").target("_blank");
        this.P().__localize("_ label.misc.globaldiagram").__colon().A(ha.href(src + ".png").target("_blank")).__escape("png")._A().__dash().A(ha.href(src + ".svg").target("_blank")).__escape("svg")._A().__dash().A(ha.href(src + ".puml").target("_blank")).__escape("puml")._A()._P();
        return true;
    }
}

