/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.corpus;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.htmlproducers.corpus.CorpusCommandBoxUtils;
import fr.exemole.bdfserver.htmlproducers.corpus.CorpusHtmlUtils;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.permission.PermissionSummary;
import net.mapeadores.util.html.CommandBox;

public class FicheDiscardFormHtmlProducer
extends BdfServerHtmlProducer {
    private final PermissionSummary permissionSummary;
    private final FicheMeta ficheMeta;

    public FicheDiscardFormHtmlProducer(BdfParameters bdfParameters, FicheMeta ficheMeta) {
        super(bdfParameters);
        this.permissionSummary = bdfParameters.getPermissionSummary();
        this.ficheMeta = ficheMeta;
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addJsLib(BdfJsLibs.COMMANDVEIL);
        this.addThemeCss("corpus.css");
    }

    @Override
    public void printHtml() {
        this.start();
        CorpusHtmlUtils.printFicheHeader(this, this.ficheMeta, this.workingLang, this.formatLocale);
        this.printCommandMessageUnit();
        if (!this.permissionSummary.isSubsetAdmin(this.ficheMeta.getSubsetKey())) {
            this.P().EM().__localize("_ info.corpus.removebyadmin")._EM()._P();
        }
        CommandBox commandBox = CommandBox.init().action("corpus").family("CRP").veil(true).errorPage("fiche-discardform").page("fiche-retrieveform");
        CorpusCommandBoxUtils.printFicheDiscardBox(this, commandBox, this.ficheMeta, this.workingLang, this.formatLocale);
        this.end();
    }
}

