/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.album;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.html.jslib.IllustrationJsLibs;
import net.fichotheque.album.Album;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.JsObject;
import net.mapeadores.util.logging.CommandMessage;

public class IllustrationUploadHtmlProducer
extends BdfServerHtmlProducer {
    private final Album album;
    private final String appelant;
    private final boolean newUpload;

    private IllustrationUploadHtmlProducer(BdfParameters bdfParameters, Album album, String appelant, boolean newUpload) {
        super(bdfParameters);
        this.album = album;
        this.appelant = appelant;
        this.newUpload = newUpload;
        this.addJsLib(IllustrationJsLibs.UPLOAD);
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addThemeCss("illustration.css");
    }

    public static IllustrationUploadHtmlProducer newNewUpload(BdfParameters bdfParameters, Album album, String appelant) {
        IllustrationUploadHtmlProducer producer = new IllustrationUploadHtmlProducer(bdfParameters, album, appelant, true);
        return producer;
    }

    public static IllustrationUploadHtmlProducer newReplaceUpload(BdfParameters bdfParameters, Album album, String appelant) {
        IllustrationUploadHtmlProducer producer = new IllustrationUploadHtmlProducer(bdfParameters, album, appelant, false);
        producer.setBodyCssClass("global-body-Transparent");
        return producer;
    }

    @Override
    public void printHtml() {
        String clientId = this.generateId();
        JsObject args = JsObject.init().put("clientId", clientId).put("appelant", this.appelant).put("newUpload", this.newUpload).put("album", this.album.getSubsetName());
        if (this.newUpload) {
            args.put("errorPage", "illustration-upload-new").put("resultPage", "illustration-change");
        } else {
            args.put("errorPage", "illustration-upload-replace").put("resultPage", "illustration-upload-confirm");
        }
        CommandMessage cm = this.getCommandMessage();
        if (cm != null) {
            args.put("errorMessage", this.getLocalization(cm));
        }
        this.startLoc(this.newUpload ? "_ title.album.newupload" : "_ title.album.replaceupload");
        this.SCRIPT().__jsObject("Illustration.Upload.ARGS", args)._SCRIPT();
        this.DIV(HA.id(clientId).classes("illustration-Client"))._DIV();
        this.end();
    }
}

