/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.album;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.jslib.IllustrationJsLibs;
import fr.exemole.bdfserver.tools.configuration.ConfigurationUtils;
import net.fichotheque.album.Album;
import net.fichotheque.album.Illustration;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.JsObject;

public class IllustrationChangeHtmlProducer
extends BdfServerHtmlProducer {
    private final Album album;
    private Illustration illustration;
    private final String appelant;
    private String tmpFileName;
    private String changeType;

    private IllustrationChangeHtmlProducer(BdfParameters bdfParameters, Album album, String appelant) {
        super(bdfParameters);
        this.addThemeCss("illustration.css");
        this.setBodyCssClass("global-body-ToolWindow");
        this.album = album;
        this.appelant = appelant;
        this.addJsLib(IllustrationJsLibs.CHANGE);
    }

    public static IllustrationChangeHtmlProducer newTmpFileCreate(BdfParameters bdfParameters, Album album, String appelant, String tmpFileName) {
        IllustrationChangeHtmlProducer htmlProducer = new IllustrationChangeHtmlProducer(bdfParameters, album, appelant);
        htmlProducer.tmpFileName = tmpFileName;
        htmlProducer.changeType = "creation";
        return htmlProducer;
    }

    public static IllustrationChangeHtmlProducer newTmpFileChange(BdfParameters bdfParameters, Album album, String appelant, String tmpFileName) {
        IllustrationChangeHtmlProducer htmlProducer = new IllustrationChangeHtmlProducer(bdfParameters, album, appelant);
        htmlProducer.tmpFileName = tmpFileName;
        htmlProducer.changeType = "tmpfile";
        return htmlProducer;
    }

    public static IllustrationChangeHtmlProducer newIllustrationChange(BdfParameters bdfParameters, Album album, String appelant, Illustration illustration, String tmpFileName) {
        IllustrationChangeHtmlProducer htmlProducer = new IllustrationChangeHtmlProducer(bdfParameters, album, appelant);
        htmlProducer.illustration = illustration;
        htmlProducer.tmpFileName = tmpFileName;
        htmlProducer.changeType = "illustration";
        return htmlProducer;
    }

    @Override
    public void printHtml() {
        String clientId = this.generateId();
        JsObject args = JsObject.init().put("clientId", clientId).put("changeType", this.changeType).put("appelant", this.appelant).put("tmpFileName", this.getTmpFileName()).put("album", this.album.getSubsetName()).put("illustrationId", this.getIllustrationId()).put("imagePath", this.getImagePath()).put("originalFileName", this.getOriginalFileName());
        this.startLoc("_ title.album.illustration");
        this.SCRIPT().__jsObject("Illustration.Change.ARGS", args)._SCRIPT();
        this.DIV(HA.id(clientId).classes("illustration-Client"))._DIV();
        this.end();
    }

    private Integer getIllustrationId() {
        if (this.illustration != null) {
            return this.illustration.getId();
        }
        return null;
    }

    private String getImagePath() {
        if (this.tmpFileName != null) {
            return ConfigurationUtils.getTmpRelativeUrl(this.tmpFileName);
        }
        return "illustrations/" + this.illustration.getFileName();
    }

    private String getTmpFileName() {
        if (this.tmpFileName != null) {
            return this.tmpFileName;
        }
        return "_ORIGINAL";
    }

    private String getOriginalFileName() {
        if (this.illustration != null) {
            return this.illustration.getFileName();
        }
        return null;
    }
}

