/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.album;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.jslib.BdfJsLibs;
import fr.exemole.bdfserver.htmlproducers.album.AlbumCommandBoxUtils;
import fr.exemole.bdfserver.htmlproducers.album.AlbumHtmlUtils;
import java.util.List;
import net.fichotheque.album.Illustration;
import net.fichotheque.junction.JunctionsBySubset;
import net.fichotheque.permission.PermissionSummary;
import net.fichotheque.tools.permission.PermissionSubsetEligibility;
import net.fichotheque.utils.JunctionUtils;
import net.mapeadores.util.html.CommandBox;

public class IllustrationAdminFormHtmlProducer
extends BdfServerHtmlProducer {
    private final Illustration illustration;
    private final PermissionSummary permissionSummary;
    private final boolean isSubsetAdmin;

    public IllustrationAdminFormHtmlProducer(BdfParameters bdfParameters, Illustration illustration) {
        super(bdfParameters);
        this.illustration = illustration;
        this.permissionSummary = bdfParameters.getPermissionSummary();
        this.isSubsetAdmin = this.permissionSummary.isSubsetAdmin(illustration.getSubsetKey());
        this.addJsLib(BdfJsLibs.COMMANDTEST);
        this.addJsLib(BdfJsLibs.COMMANDVEIL);
        this.addJsLib(BdfJsLibs.APPELANT);
        this.addThemeCss("album.css");
        this.addStyle(AlbumHtmlUtils.getThumbnailSize(illustration.getAlbum().getAlbumMetadata()));
    }

    @Override
    public void printHtml() {
        PermissionSubsetEligibility subsetEligibity = PermissionSubsetEligibility.read(this.permissionSummary);
        List<JunctionsBySubset> junctionsBySubsetList = JunctionUtils.filterJunctions(this.illustration, subsetEligibity, (short)1);
        this.start();
        AlbumHtmlUtils.printIllustrationToolbar(this, "illustration-adminform", this.illustration, this.isSubsetAdmin);
        this.printCommandMessageUnit();
        CommandBox commandBox = CommandBox.init().action("album").family("ALB").veil(true).page("illustration-adminform");
        if (!junctionsBySubsetList.isEmpty()) {
            AlbumCommandBoxUtils.printJunctionRemoveBox(this, commandBox, this.illustration, junctionsBySubsetList, this.permissionSummary, this.bdfUser);
        }
        AlbumCommandBoxUtils.printJunctionAddBox(this, commandBox, this.illustration);
        commandBox.errorPage("illustration-adminform").page("_message");
        AlbumCommandBoxUtils.printIllustrationRemoveBox(this, commandBox, this.illustration);
        this.end();
    }
}

