/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers.album;

import fr.exemole.bdfserver.html.consumers.Button;
import fr.exemole.bdfserver.tools.BH;
import fr.exemole.bdfserver.tools.BdfHref;
import net.fichotheque.album.Album;
import net.fichotheque.album.Illustration;
import net.fichotheque.album.metadata.AlbumMetadata;
import net.mapeadores.util.awt.ResizeInfo;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.html.TrustedHtml;

public final class AlbumHtmlUtils {
    private AlbumHtmlUtils() {
    }

    public static TrustedHtml getThumbnailSize(AlbumMetadata albumMetadata) {
        int height;
        ResizeInfo resizeInfo = albumMetadata.getResizeInfo("_mini");
        StringBuilder buf = new StringBuilder();
        buf.append(".album-Thumbnail {");
        int width = resizeInfo.getWidth();
        if (width > 0) {
            buf.append("width: ");
            buf.append(width);
            buf.append("px;");
        }
        if ((height = resizeInfo.getHeight()) > 0) {
            buf.append("height: ");
            buf.append(height);
            buf.append("px;");
        }
        buf.append('}');
        return new TrustedHtml(buf.toString());
    }

    public static boolean printAlbumToolbar(HtmlPrinter hp, String pageActu, Album album) {
        Button button = Button.link().style("transparent");
        hp.NAV("subset-Toolbar").DIV("subset-Buttons").SPAN("subset-SmallLabel").__localize("_ title.global.commands").__colon()._SPAN().__(AlbumHtmlUtils.link(button, "action-Metadata", album, "album-metadataform", "_ link.album.albummetadataform", pageActu)).__(AlbumHtmlUtils.link(button, "action-Advanced", album, "album-advancedcommands", "_ link.album.albumadvancedcommands", pageActu)).__(AlbumHtmlUtils.refresh(button, album))._DIV()._NAV();
        return true;
    }

    public static boolean printIllustrationToolbar(HtmlPrinter hp, String pageActu, Illustration illustration, boolean isSubsetAdmin) {
        Button button = Button.link().style("transparent");
        String fileName = illustration.getFileName();
        hp.HEADER("subset-ItemHeader album-IllustrationHeader").DIV("album-IllustrationThumbnail").A(HA.href("illustrations/" + fileName)).IMG(HA.src("illustrations/_mini/" + fileName))._A()._DIV().H1().__escape(fileName)._H1()._HEADER();
        hp.NAV("subset-Toolbar").DIV("subset-Buttons").SPAN("subset-SmallLabel").__localize("_ title.global.commands").__colon()._SPAN().__(AlbumHtmlUtils.link(button, "action-IllustrationEdit", illustration, "illustration-adminform", "_ link.album.illustrationadminform", pageActu)).__(AlbumHtmlUtils.link(button, "action-Advanced", illustration, "illustration-advancedcommands", "_ link.album.illustrationadvancedcommands", pageActu)).__(AlbumHtmlUtils.refresh(button, illustration.getAlbum()))._DIV()._NAV();
        return true;
    }

    public static String getAlbumDimMessageKey(String dimType) {
        switch (dimType) {
            case "fixed-width": {
                return "_ label.album.albumdimtype_fixedwidth";
            }
            case "fixed-height": {
                return "_ label.album.albumdimtype_fixedheight";
            }
            case "max-width": {
                return "_ label.album.albumdimtype_maxwidth";
            }
            case "max-height": {
                return "_ label.album.albumdimtype_maxheight";
            }
            case "max-dim": {
                return "_ label.album.albumdimtype_maxdim";
            }
        }
        throw new IllegalArgumentException("unknown type " + dimType);
    }

    private static Button link(Button button, String action, Object object, String page, String titleLocKey, String currentPage) {
        if (currentPage.equals(page)) {
            return button.current(true).href(null).action(action).tooltip(null);
        }
        BdfHref href = BH.domain("album").page(page);
        if (object instanceof Album) {
            href.subset((Album)object);
        } else if (object instanceof Illustration) {
            href.subsetItem((Illustration)object);
        }
        return button.current(false).href(href).action(action).tooltipMessage(titleLocKey);
    }

    private static Button refresh(Button button, Album album) {
        return button.current(false).href(BH.domain("album").page("album").subset(album)).action("action-Refresh").tooltipMessage("_ link.global.reload").target("List");
    }
}

