/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.htmlproducers;

import fr.exemole.bdfserver.api.instruction.OutputParameters;
import fr.exemole.bdfserver.api.providers.HtmlProducerProvider;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import fr.exemole.bdfserver.html.MessageHtmlProducer;
import fr.exemole.bdfserver.htmlproducers.addenda.AddendaHtmlProducerFactory;
import fr.exemole.bdfserver.htmlproducers.administration.AdministrationHtmlProducerFactory;
import fr.exemole.bdfserver.htmlproducers.album.AlbumHtmlProducerFactory;
import fr.exemole.bdfserver.htmlproducers.configuration.ConfigurationHtmlProducerFactory;
import fr.exemole.bdfserver.htmlproducers.corpus.CorpusHtmlProducerFactory;
import fr.exemole.bdfserver.htmlproducers.edition.EditionHtmlProducerFactory;
import fr.exemole.bdfserver.htmlproducers.exportation.ExportationHtmlProducerFactory;
import fr.exemole.bdfserver.htmlproducers.importation.ImportationHtmlProducerFactory;
import fr.exemole.bdfserver.htmlproducers.mailing.MailingHtmlProducerFactory;
import fr.exemole.bdfserver.htmlproducers.main.MainHtmlProducerFactory;
import fr.exemole.bdfserver.htmlproducers.misc.MiscHtmlProducerFactory;
import fr.exemole.bdfserver.htmlproducers.pioche.PiocheHtmlProducerFactory;
import fr.exemole.bdfserver.htmlproducers.selection.SelectionHtmlProducerFactory;
import fr.exemole.bdfserver.htmlproducers.sphere.SphereHtmlProducerFactory;
import fr.exemole.bdfserver.htmlproducers.thesaurus.ThesaurusHtmlProducerFactory;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.jslib.JsLib;
import net.mapeadores.util.logging.ErrorMessageException;

public final class CoreHtmlProducerProvider
implements HtmlProducerProvider {
    public static final HtmlProducerProvider UNIQUE_INSTANCE = new CoreHtmlProducerProvider();

    private CoreHtmlProducerProvider() {
    }

    @Override
    public HtmlProducer getHtmlProducer(OutputParameters parameters) throws ErrorMessageException {
        if (parameters.getOutput().equals("_message")) {
            return MessageHtmlProducer.init(parameters).setBdfCommandResult(parameters.getBdfCommandResult());
        }
        BdfServerHtmlProducer htmlProducer = this.getBdfHtmlProducer(parameters);
        if (htmlProducer != null) {
            htmlProducer.setBdfCommandResult(parameters.getBdfCommandResult());
            String page = parameters.getDomain().getFirstPart() + ":" + parameters.getOutput();
            for (JsLib jsLib : parameters.getBdfServer().getJsLibManager().getCustomJsLibList(page)) {
                htmlProducer.addJsLib(jsLib);
            }
        }
        return htmlProducer;
    }

    private BdfServerHtmlProducer getBdfHtmlProducer(OutputParameters parameters) throws ErrorMessageException {
        switch (parameters.getDomain().getFirstPart()) {
            case "addenda": {
                return AddendaHtmlProducerFactory.getHtmlProducer(parameters);
            }
            case "administration": {
                return AdministrationHtmlProducerFactory.getHtmlProducer(parameters);
            }
            case "album": {
                return AlbumHtmlProducerFactory.getHtmlProducer(parameters);
            }
            case "configuration": {
                return ConfigurationHtmlProducerFactory.getHtmlProducer(parameters);
            }
            case "corpus": {
                return CorpusHtmlProducerFactory.getHtmlProducer(parameters);
            }
            case "edition": {
                return EditionHtmlProducerFactory.getHtmlProducer(parameters);
            }
            case "exportation": {
                return ExportationHtmlProducerFactory.getHtmlProducer(parameters);
            }
            case "importation": {
                return ImportationHtmlProducerFactory.getHtmlProducer(parameters);
            }
            case "mailing": {
                return MailingHtmlProducerFactory.getHtmlProducer(parameters);
            }
            case "main": {
                return MainHtmlProducerFactory.getHtmlProducer(parameters);
            }
            case "misc": {
                return MiscHtmlProducerFactory.getHtmlProducer(parameters);
            }
            case "pioche": {
                return PiocheHtmlProducerFactory.getHtmlProducer(parameters);
            }
            case "selection": {
                return SelectionHtmlProducerFactory.getHtmlProducer(parameters);
            }
            case "sphere": {
                return SphereHtmlProducerFactory.getHtmlProducer(parameters);
            }
            case "thesaurus": {
                return ThesaurusHtmlProducerFactory.getHtmlProducer(parameters);
            }
        }
        return null;
    }
}

