/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.html.consumers;

import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.localisation.Litteral;

public class SelectOption
implements BiConsumer<HtmlPrinter, Object> {
    private final String value;
    private Object textL10nObject;

    public SelectOption(String value) {
        this.value = value;
    }

    public String value() {
        return this.value;
    }

    public SelectOption textL10nObject(Object textL10nObject) {
        this.textL10nObject = textL10nObject;
        return this;
    }

    public SelectOption text(String text) {
        this.textL10nObject = text == null ? null : new Litteral(text);
        return this;
    }

    @Override
    public void accept(HtmlPrinter hp, Object object) {
        boolean selected = false;
        if (object != null) {
            selected = object instanceof Boolean ? ((Boolean)object).booleanValue() : object.equals(this.value);
        }
        hp.OPTION(this.value, selected);
        if (this.textL10nObject != null) {
            hp.__localize(this.textL10nObject);
        }
        hp._OPTION();
    }

    public static SelectOption init(String value) {
        return new SelectOption(value);
    }

    public static Consumer<HtmlPrinter> consumer(Collection<SelectOption> selectOptions, Object currentValue) {
        return new CollectionConsumer(selectOptions, currentValue);
    }

    public static Consumer<HtmlPrinter> consumer(SelectOption[] selectOptionArray, Object currentValue) {
        return new ArrayConsumer(selectOptionArray, currentValue);
    }

    private static class CollectionConsumer
    implements Consumer<HtmlPrinter> {
        private final Collection<SelectOption> selectOptions;
        private final Object currentValue;

        private CollectionConsumer(Collection<SelectOption> selectOptions, Object currentValue) {
            this.selectOptions = selectOptions;
            this.currentValue = currentValue;
        }

        @Override
        public void accept(HtmlPrinter hp) {
            for (SelectOption option : this.selectOptions) {
                hp.__(option, this.currentValue);
            }
        }
    }

    private static class ArrayConsumer
    implements Consumer<HtmlPrinter> {
        private final SelectOption[] selectOptions;
        private final Object currentValue;

        private ArrayConsumer(SelectOption[] selectOptions, Object currentValue) {
            this.selectOptions = selectOptions;
            this.currentValue = currentValue;
        }

        @Override
        public void accept(HtmlPrinter hp) {
            for (SelectOption option : this.selectOptions) {
                hp.__(option, this.currentValue);
            }
        }
    }
}

