/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.html.consumers;

import java.util.function.Consumer;
import net.mapeadores.util.html.ConsumerFactory;
import net.mapeadores.util.html.HA;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.html.HtmlWrapper;
import net.mapeadores.util.html.WrapperFactory;
import net.mapeadores.util.localisation.Litteral;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.Message;

public class Button
implements Consumer<HtmlPrinter> {
    public static final HtmlWrapper COMMAND = WrapperFactory.div("command-Submit");
    public static final Consumer<HtmlPrinter> ICON = ConsumerFactory.emptySpan("global-button-Icon");
    public static final String STANDARD_STYLE = "standard";
    public static final String LINK_STYLE = "link";
    public static final String TRANSPARENT_STYLE = "transparent";
    private static final String LINK_TYPE = "link";
    private final String type;
    private String style = "standard";
    private String href;
    private String target;
    private Object textL10nObject;
    private String text;
    private String tooltipLocKey;
    private String tooltip;
    private Message tooltipMessage;
    private String action;
    private String formId;
    private String buttonId;
    private String shortcutKey;
    private String shortcutTooltip;
    private boolean ficheForm;
    private boolean current;

    private Button(String type) {
        this.type = type;
        if (type.equals("link")) {
            this.style = "link";
        }
    }

    public Button action(String action) {
        this.action = action;
        return this;
    }

    public Button current(boolean current) {
        this.current = current;
        return this;
    }

    public Button href(CharSequence href) {
        this.href = href == null ? null : href.toString();
        return this;
    }

    public Button buttonId(String buttonId) {
        this.buttonId = buttonId;
        return this;
    }

    public Button formId(String formId) {
        this.formId = formId;
        return this;
    }

    public Button ficheForm(boolean ficheForm) {
        this.ficheForm = ficheForm;
        return this;
    }

    public Button shortcutKey(String shortcutKey) {
        this.shortcutKey = shortcutKey;
        return this;
    }

    public Button shortcutTooltip(String shortcutTooltip) {
        this.shortcutTooltip = shortcutTooltip;
        return this;
    }

    public Button style(String style) {
        this.style = style;
        return this;
    }

    public Button target(String target) {
        this.target = target;
        return this;
    }

    public Button text(String text) {
        this.textL10nObject = text == null ? null : new Litteral(text);
        return this;
    }

    public Button textL10nObject(Object textL10nObject) {
        this.textL10nObject = textL10nObject;
        return this;
    }

    public Button textMessage(String textLocKey, Object ... values) {
        this.textL10nObject = LocalisationUtils.toMessage(textLocKey, values);
        return this;
    }

    public Button tooltip(String tooltip) {
        this.tooltip = tooltip;
        this.tooltipLocKey = null;
        this.tooltipMessage = null;
        return this;
    }

    public Button tooltipMessage(String tooltipLocKey) {
        this.tooltip = null;
        this.tooltipLocKey = tooltipLocKey;
        this.tooltipMessage = null;
        return this;
    }

    public Button tooltipMessage(String tooltipLocKey, Object ... values) {
        this.tooltip = null;
        this.tooltipLocKey = null;
        this.tooltipMessage = LocalisationUtils.toMessage(tooltipLocKey, values);
        return this;
    }

    public Button tooltipMessage(Message tooltipMessage) {
        this.tooltip = null;
        this.tooltipLocKey = null;
        this.tooltipMessage = tooltipMessage;
        return this;
    }

    public static Button button() {
        return new Button("button");
    }

    public static Button submit() {
        return new Button("submit");
    }

    public static Button submit(String textLocKey) {
        return new Button("submit").textL10nObject(textLocKey);
    }

    public static Button submit(String action, String textLocKey) {
        return new Button("submit").textL10nObject(textLocKey).action(action);
    }

    public static Button link() {
        return new Button("link");
    }

    public static Button link(String href) {
        return new Button("link").href(href);
    }

    @Override
    public void accept(HtmlPrinter hp) {
        if (this.type.equals("link")) {
            this.acceptLink(hp);
        } else {
            this.acceptButton(hp);
        }
    }

    private void acceptButton(HtmlPrinter hp) {
        HtmlAttributes buttonAttributes = HA.type(this.type).classes(this.getButtonClass()).addClass(this.action != null, this.action);
        this.checkTooltip(hp, buttonAttributes);
        if (this.formId != null) {
            buttonAttributes.attr("form", this.formId);
        }
        if (this.buttonId != null) {
            buttonAttributes.id(this.buttonId);
        }
        if (this.ficheForm) {
            buttonAttributes.attr("data-ficheform-role", "submit-button");
        }
        if (this.shortcutKey != null) {
            buttonAttributes.attr("data-shortcut-key", this.shortcutKey);
        }
        if (this.shortcutTooltip != null) {
            buttonAttributes.attr("data-shortcut-tooltip", this.shortcutTooltip);
        }
        hp.BUTTON(buttonAttributes);
        this.checkIcon(hp);
        this.checkText(hp);
        hp._BUTTON();
    }

    private void acceptLink(HtmlPrinter hp) {
        if (this.current) {
            hp.SPAN(HA.classes(this.getButtonClass()).addClass("global-button-Current").addClass(this.action != null, this.action));
            this.checkIcon(hp);
            this.checkText(hp);
            hp._SPAN();
        } else {
            HtmlAttributes linkAttributes = HA.href(this.href).target(this.target).classes(this.getButtonClass()).addClass(this.action != null, this.action);
            this.checkTooltip(hp, linkAttributes);
            if (this.shortcutKey != null) {
                linkAttributes.attr("data-shortcut-key", this.shortcutKey);
            }
            if (this.shortcutTooltip != null) {
                linkAttributes.attr("data-shortcut-tooltip", this.shortcutTooltip);
            }
            hp.A(linkAttributes);
            this.checkIcon(hp);
            this.checkText(hp);
            hp._A();
        }
    }

    private void checkTooltip(HtmlPrinter hp, HtmlAttributes htmlAttributes) {
        String tooltipText = this.getTooltipText(hp);
        if (tooltipText != null) {
            htmlAttributes.title(tooltipText);
        }
    }

    private String getTooltipText(HtmlPrinter hp) {
        if (this.tooltipLocKey != null) {
            return hp.getLocalization(this.tooltipLocKey);
        }
        if (this.tooltip != null) {
            return this.tooltip;
        }
        if (this.tooltipMessage != null) {
            return hp.getLocalization(this.tooltipMessage);
        }
        return null;
    }

    private void checkText(HtmlPrinter hp) {
        if (this.textL10nObject != null) {
            hp.SPAN("global-button-Text").__localize(this.textL10nObject)._SPAN();
        } else if (this.text != null) {
            hp.SPAN("global-button-Text").__escape(this.text)._SPAN();
        }
    }

    private void checkIcon(HtmlPrinter hp) {
        if (this.action != null) {
            hp.__(ICON);
        }
    }

    private String getButtonClass() {
        switch (this.style) {
            case "link": {
                return "global-button-Link";
            }
            case "transparent": {
                return "global-button-Transparent";
            }
        }
        return "global-button-Standard";
    }
}

