/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.html;

import fr.exemole.bdfserver.tools.instruction.BdfInstructionUtils;
import java.util.LinkedHashMap;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;

public class ParameterMap
extends LinkedHashMap<String, String> {
    public ParameterMap command(String commandName) {
        this.put("cmd", commandName);
        return this;
    }

    public ParameterMap command(String domain, String commandName) {
        this.put("cmd", BdfInstructionUtils.getAbsoluteCommandName(domain, commandName));
        return this;
    }

    public ParameterMap borderFrameStyle() {
        this.put("bdf-framestyle", "border");
        return this;
    }

    public ParameterMap param(String name, String value) {
        if (value == null) {
            this.remove(name);
        } else {
            this.put(name, value);
        }
        return this;
    }

    public ParameterMap page(String pageName) {
        this.put("page", pageName);
        return this;
    }

    public ParameterMap page(String domain, String pageName) {
        this.put("page", BdfInstructionUtils.getAbsolutePageName(domain, pageName));
        return this;
    }

    public ParameterMap errorPage(String pageName) {
        this.put("page-err", pageName);
        return this;
    }

    public ParameterMap subset(Subset subset) {
        return this.subset(subset.getSubsetKey());
    }

    public ParameterMap subset(SubsetKey subsetKey) {
        this.put(subsetKey.getCategoryString(), subsetKey.getSubsetName());
        return this;
    }

    public ParameterMap subsetItem(SubsetItem subsetItem) {
        this.put("id", String.valueOf(subsetItem.getId()));
        return this;
    }

    public static ParameterMap init() {
        return new ParameterMap();
    }
}

