/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.html;

import fr.exemole.bdfserver.html.BdfJsLibAssembly;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.mapeadores.util.buildinfo.BuildInfo;
import net.mapeadores.util.html.HtmlAttributes;
import net.mapeadores.util.html.HtmlPrinter;
import net.mapeadores.util.html.HtmlPrinterUtils;
import net.mapeadores.util.html.HtmlProducer;
import net.mapeadores.util.html.PageHtmlPrinter;
import net.mapeadores.util.jslib.JsAnalyser;
import net.mapeadores.util.jslib.JsLib;
import net.mapeadores.util.logging.CommandMessage;
import net.mapeadores.util.text.RelativePath;

public abstract class BdfHtmlProducer
extends PageHtmlPrinter
implements HtmlProducer {
    private final JsAnalyser jsAnalyser;
    private final BuildInfo buildInfo;
    private final Set<String> themeCssPathSet = new LinkedHashSet<String>();
    private final Set<String> supplementaryCssPathSet = new LinkedHashSet<String>();
    private final Set<String> customCssPathSet = new LinkedHashSet<String>();
    private BdfJsLibAssembly jsLibAssembly = null;
    private String reversePath = "";
    private CommandMessage commandMessage;
    private boolean withFicheCss = false;
    private boolean withFicheElementCss = false;
    private boolean withThemeElementCss = true;
    private boolean withFontAwesome = false;
    private List<HtmlAttributes> supplementaryIconAttributesList = null;
    private StringBuilder logBuffer;

    public BdfHtmlProducer(JsAnalyser jsAnalyser, BuildInfo buildInfo) {
        this.jsAnalyser = jsAnalyser;
        this.buildInfo = buildInfo;
    }

    public final void addThemeCss(String ... cssThemeFile) {
        for (String value : cssThemeFile) {
            this.themeCssPathSet.add("theme/css/" + value);
        }
    }

    public final void addExtensionThemeCss(String extensionName, String ... cssThemeFile) {
        for (String value : cssThemeFile) {
            this.themeCssPathSet.add(StorageUtils.getExtensionResourcePath(extensionName, "theme/css/" + value));
        }
    }

    public final void addAppThemeCss(String appName, String ... cssThemeFile) {
        for (String value : cssThemeFile) {
            this.themeCssPathSet.add(StorageUtils.getAppResourcePath(appName, "theme/css/" + value));
        }
    }

    public final void addSupplementaryCss(RelativePath path) {
        this.supplementaryCssPathSet.add(path.getPath());
    }

    public final void addCustomCss(RelativePath path) {
        this.customCssPathSet.add(path.getPath());
    }

    public final void addFicheCss(boolean withFicheElementCss) {
        this.withFicheCss = true;
        this.withFicheElementCss = withFicheElementCss;
    }

    public final void addFontAwesomeCss() {
        this.withFontAwesome = true;
    }

    public final void ignoreThemeElementCss() {
        this.withThemeElementCss = false;
    }

    public final void setReversePath(String reversePath) {
        this.reversePath = reversePath == null ? "" : reversePath;
    }

    public String getReversePath() {
        return this.reversePath;
    }

    public BdfJsLibAssembly getJsLibAssembly() {
        return this.jsLibAssembly;
    }

    public void setCommandMessage(CommandMessage commandMessage) {
        this.commandMessage = commandMessage;
    }

    public void setSupplementaryIconAttributesList(List<HtmlAttributes> supplementaryIconAttributesList) {
        this.supplementaryIconAttributesList = supplementaryIconAttributesList;
    }

    public CommandMessage getCommandMessage() {
        return this.commandMessage;
    }

    public boolean printCommandMessage() {
        return HtmlPrinterUtils.printCommandMessage((HtmlPrinter)this, this.getCommandMessage(), "global-DoneMessage", "global-ErrorMessage");
    }

    public void addLog(String logMessage) {
        if (this.logBuffer == null) {
            this.logBuffer = new StringBuilder();
            this.logBuffer.append(logMessage);
        } else {
            this.logBuffer.append("\n");
            this.logBuffer.append(logMessage);
        }
    }

    public String getLog() {
        if (this.logBuffer == null) {
            return "";
        }
        return this.logBuffer.toString();
    }

    protected void setIcons() {
        this.addIconPng(this.reversePath + StorageUtils.ICON.toString(), "16");
        this.addIconPng(this.reversePath + StorageUtils.ICON32.toString(), "32");
        if (this.supplementaryIconAttributesList != null) {
            for (HtmlAttributes ha : this.supplementaryIconAttributesList) {
                this.addIcon(ha.href(this.reversePath + ha.href()));
            }
        }
    }

    protected void resolveJavascript() {
        if (this.jsLibAssembly != null) {
            String suffix = "";
            if (this.buildInfo != null) {
                suffix = "?v=" + this.buildInfo.getVersion();
            }
            this.jsLibAssembly.resolve(this, this.reversePath, suffix);
        }
    }

    protected void resolveCss() {
        String suffix = "";
        if (this.buildInfo != null) {
            suffix = "?v=" + this.buildInfo.getVersion();
        }
        if (this.withFontAwesome) {
            this.addCssUrl(this.reversePath + "third-lib/fontawesome/css/fontawesome.css" + suffix);
            this.addCssUrl(this.reversePath + "third-lib/fontawesome/css/solid.css" + suffix);
        }
        if (this.withFicheElementCss) {
            this.addCssUrl(this.reversePath + "css/fiche-elements.css" + suffix);
        }
        if (this.withFicheCss) {
            this.addCssUrl(this.reversePath + "css/_ficheblockelements.css" + suffix);
            this.addCssUrl(this.reversePath + "css/_predefinedclasses.css" + suffix);
            this.addCssUrl(this.reversePath + "css/fiche-classes.css" + suffix);
        }
        this.resolveThemeCss(suffix);
        for (String supplementaryPath : this.supplementaryCssPathSet) {
            this.addCssUrl(this.reversePath + supplementaryPath);
        }
        if (this.withFicheCss) {
            this.addCssUrl(this.reversePath + "custom/fiche.css");
        }
        this.addCssUrl(this.reversePath + "custom/theme.css");
        for (String customPath : this.customCssPathSet) {
            this.addCssUrl(this.reversePath + customPath);
        }
    }

    private void resolveThemeCss(String suffix) {
        if (this.jsLibAssembly != null) {
            for (String path : this.jsLibAssembly.getJsLibCssPaths()) {
                this.themeCssPathSet.add(path);
            }
        }
        if (this.withThemeElementCss) {
            this.addCssUrl(this.reversePath + "theme/css/_normalize.css" + suffix);
            this.addCssUrl(this.reversePath + "theme/css/_default.css" + suffix);
        }
        this.addCssUrl(this.reversePath + "theme/css/_overlay.css" + suffix);
        this.addCssUrl(this.reversePath + "theme/css/_global.css" + suffix);
        this.addCssUrl(this.reversePath + "theme/css/_grid.css" + suffix);
        this.addCssUrl(this.reversePath + "theme/css/_action.css" + suffix);
        this.addCssUrl(this.reversePath + "theme/css/_family.css" + suffix);
        this.addCssUrl(this.reversePath + "theme/css/_codemirror.css" + suffix);
        if (this.isWithJavascript()) {
            this.addCssUrl(this.reversePath + "theme/css/_javascript.css" + suffix);
        }
        for (String path : this.themeCssPathSet) {
            this.addCssUrl(this.reversePath + path + suffix);
        }
    }

    public final void setMainStorageKey(String ... keyParts) {
        this.testJsLibAssembly();
        this.jsLibAssembly.setMainStorageKey(String.join((CharSequence)"/", keyParts));
    }

    public final void addJsLib(JsLib jsLib) {
        this.testJsLibAssembly();
        this.jsLibAssembly.addJsLib(jsLib);
    }

    public abstract void printHtml();

    public abstract void start(String var1);

    public void startLoc(String titleMessageKey) {
        this.start(this.getLocalization(titleMessageKey));
    }

    public void startLoc(String titleMessageKey, Object ... messageValues) {
        this.start(this.getLocalization(titleMessageKey, messageValues));
    }

    @Override
    public void writeHtml(Appendable appendable) {
        this.initPrinter(appendable);
        this.printHtml();
    }

    private void testJsLibAssembly() {
        if (this.jsLibAssembly == null) {
            this.jsLibAssembly = new BdfJsLibAssembly(this.jsAnalyser);
        }
    }
}

