/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.ParentRecursivityException;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.fichotheque.thesaurus.policies.DynamicEditPolicy;
import net.fichotheque.tools.thesaurus.ThesaurusTools;
import net.fichotheque.utils.ThesaurusUtils;
import net.mapeadores.util.exceptions.ImplementationException;
import net.mapeadores.util.localisation.Langs;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.Label;

public class ThesaurusCleaningCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "ThesaurusCleaning";
    public static final String COMMANDKEY = "_ THS-06";
    private Thesaurus thesaurus;

    public ThesaurusCleaningCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        Integer[] result;
        try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
            result = this.clean(session.getFichothequeEditor().getThesaurusEditor(this.thesaurus));
        }
        this.setDone("_ done.thesaurus.thesauruscleaning", result);
        this.putResultObject("obj.thesaurus", this.thesaurus);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.thesaurus = this.requestHandler.getMandatoryThesaurus();
        this.checkSubsetAdmin(this.thesaurus);
        if (!this.checkConfirmation()) {
            throw BdfErrors.error("_ error.empty.confirmationcheck_remove");
        }
    }

    private Integer[] clean(ThesaurusEditor thesaurusEditor) {
        FichothequeEditor fichothequeEditor = thesaurusEditor.getFichothequeEditor();
        int nbretransfert = 0;
        DynamicEditPolicy dynamicEditPolicy = this.bdfServer.getPolicyManager().getPolicyProvider().getDynamicEditPolicy(this.thesaurus);
        Thesaurus[] checkThesaurusArray = ThesaurusUtils.getCheckThesaurusArray(this.bdfServer.getFichotheque(), dynamicEditPolicy);
        if (checkThesaurusArray != null) {
            for (Motcle motcle : this.thesaurus.getMotcleList()) {
                boolean done = this.transfer(fichothequeEditor, motcle, checkThesaurusArray);
                if (!done) continue;
                ++nbretransfert;
            }
        }
        int nbresuppression = ThesaurusUtils.removeRemoveableMotcle(thesaurusEditor);
        int nbrefusion = 0;
        if (!this.thesaurus.isIdalphaType()) {
            Langs langs = this.bdfServer.getThesaurusLangChecker().getAuthorizedLangs(this.thesaurus);
            for (Motcle motcle : this.thesaurus.getMotcleList()) {
                boolean done = this.merge(fichothequeEditor, motcle, langs);
                if (!done) continue;
                ++nbrefusion;
            }
        }
        Integer[] result = new Integer[]{nbretransfert, nbresuppression, nbrefusion};
        return result;
    }

    private boolean merge(FichothequeEditor fichothequeEditor, Motcle motcle, Langs langs) {
        int labelLength = motcle.getLabels().size();
        if (labelLength != 1) {
            return false;
        }
        Label label = (Label)motcle.getLabels().get(0);
        Motcle destination = this.thesaurus.getMotcleByLabel(label.getLabelString(), label.getLang());
        if (destination.equals(motcle)) {
            return false;
        }
        Motcle source = motcle;
        if (destination.isDescendantOf(motcle)) {
            source = destination;
            destination = motcle;
        }
        try {
            ThesaurusTools.merge(fichothequeEditor, source, destination, langs);
        }
        catch (ParentRecursivityException pre) {
            throw new ImplementationException(pre);
        }
        return true;
    }

    private boolean transfer(FichothequeEditor fichothequeEditor, Motcle motcle, Thesaurus[] verifThesaurusArray) {
        int labelLength = motcle.getLabels().size();
        if (labelLength != 1) {
            return false;
        }
        Label label = (Label)motcle.getLabels().get(0);
        for (Thesaurus verifThesaurus : verifThesaurusArray) {
            Motcle destination = verifThesaurus.getMotcleByLabel(label.getLabelString(), label.getLang());
            if (destination == null) continue;
            try {
                Langs langs = this.bdfServer.getThesaurusLangChecker().getAuthorizedLangs(destination.getThesaurus());
                ThesaurusTools.merge(fichothequeEditor, motcle, destination, langs);
            }
            catch (ParentRecursivityException pre) {
                throw new ImplementationException(pre);
            }
            return true;
        }
        return false;
    }
}

