/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.thesaurus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.ExistingIdException;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.ThesaurusEditor;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.Idalpha;
import net.mapeadores.util.text.StringUtils;

public class IdalphaChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "IdalphaChange";
    public static final String COMMANDKEY = "_ THS-09";
    public static final String NEWIDALPHA_PARAMNAME = "newidalpha";
    private Motcle motcle;
    private String newIdalpha;

    public IdalphaChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        boolean done;
        Thesaurus thesaurus = this.motcle.getThesaurus();
        try (EditSession session = this.startEditSession("thesaurus", COMMANDNAME);){
            ThesaurusEditor thesaurusEditor = session.getFichothequeEditor().getThesaurusEditor(thesaurus);
            try {
                done = thesaurusEditor.setIdalpha(this.motcle, this.newIdalpha);
            }
            catch (ParseException | ExistingIdException eia) {
                throw new ShouldNotOccurException("test done before");
            }
        }
        this.putResultObject("obj.thesaurus", thesaurus);
        this.putResultObject("obj.motcle", this.motcle);
        if (done) {
            this.setDone("_ done.thesaurus.idalphachange", new Object[0]);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.motcle = this.requestHandler.getMandatoryMotcle();
        Thesaurus thesaurus = this.motcle.getThesaurus();
        this.checkSubsetAdmin(thesaurus);
        if (!thesaurus.isIdalphaType()) {
            throw BdfErrors.unsupportedParameterValue("thesaurus", thesaurus.getSubsetName());
        }
        this.newIdalpha = StringUtils.cleanString(this.getMandatory(NEWIDALPHA_PARAMNAME));
        if (this.newIdalpha.isEmpty()) {
            throw BdfErrors.error("_ error.empty.idalpha");
        }
        if (!Idalpha.isValid(this.newIdalpha)) {
            throw BdfErrors.error("_ error.wrong.idalpha", this.newIdalpha);
        }
        Motcle other = thesaurus.getMotcleByIdalpha(this.newIdalpha);
        if (other != null) {
            throw BdfErrors.error("_ error.existing.idalpha", this.newIdalpha);
        }
    }
}

